<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="users" />

<xsl:template match="xml">
	
	<table width="100%" border="0" cellpadding="2" cellspacing="0">
		<tr class="uportal-background-med">
			<xsl:call-template name="server.name" />
		</tr>
		<tr class="uportal-background-highlight">
			<xsl:call-template name="server.memory" />
		</tr>
		<tr>
			<xsl:call-template name="server.memory.max" />
		</tr>
		<tr>
			<xsl:call-template name="server.memory.total" />
		</tr>
		<tr>
			<xsl:call-template name="server.memory.free" />
		</tr>
		<tr class="uportal-background-highlight">
			<xsl:call-template name="server.sessions" />
		</tr>
		<tr>
			<xsl:call-template name="server.sessions.total" />
		</tr>
		<tr>
			<xsl:call-template name="server.sessions.guest" />
		</tr>
		<tr>
			<xsl:call-template name="server.sessions.connected" />
		</tr>
		<tr class="uportal-background-highlight">
			<xsl:call-template name="server.users" />
		</tr>
		<xsl:if test="$users='true'">
			<xsl:call-template name="server.users.display" />
		</xsl:if>
	</table>
</xsl:template>

<xsl:template name="server.name">
	<td>&#160;</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-label" nowrap="true">
			<xsl:value-of select="./@name" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.memory">
	<td class="uportal-label" nowrap="true">Mmoire</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td>&#160;</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.memory.max">
	<td class="uportal-text" nowrap="true">Maximum (Mo)</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<xsl:value-of select="./memory/@max" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.memory.total">
	<td class="uportal-text" nowrap="true">Total (Mo)</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<xsl:value-of select="./memory/@total" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.memory.free">
	<td class="uportal-text" nowrap="true">Libre (Mo)</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<xsl:value-of select="./memory/@free" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.sessions">
	<td class="uportal-label" nowrap="true">Sessions</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td>&#160;</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.sessions.total">
	<td class="uportal-text" nowrap="true">Total</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<xsl:value-of select="./sessions/@total" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.sessions.guest">
	<td class="uportal-text" nowrap="true">Anonymes</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<xsl:value-of select="./sessions/@guest" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.sessions.connected">
	<td class="uportal-text" nowrap="true">Connects</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td class="uportal-text" nowrap="true">
			<xsl:value-of select="./sessions/@connected" />
		</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.users">
	<td class="uportal-label" nowrap="true">
		<xsl:choose>
			<xsl:when test="$users='true'">
				<a href="{$baseActionURL}"><p class="uportal-label">Utilisateurs</p></a>
			</xsl:when>
			<xsl:otherwise>
				<a href="{$baseActionURL}?users=1"><p class="uportal-label">Utilisateurs</p></a>
			</xsl:otherwise>
		</xsl:choose>
	</td>
	<xsl:for-each select="server">
		<td>&#160;</td>
		<td>&#160;</td>
	</xsl:for-each>
	<td width="100%">&#160;</td>
</xsl:template>

<xsl:template name="server.users.display">
	<tr>
		<td>&#160;</td>
		<xsl:for-each select="server">
			<td>&#160;</td>
			<td class="uportal-text" valign="top">
				<xsl:apply-templates select="./users/user" />
			</td>
		</xsl:for-each>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template match="user">
	<xsl:value-of select="./@id" /><br/>
</xsl:template>

</xsl:stylesheet>