package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataReadManager;
import org.esupportail.portal.channels.CIntranet.data.IDataWriteManager;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * DeleteDocument<br>
 * <br>
 * Cette action prend en charge la suppression d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class DeleteDocument extends IntranetAction {
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public DeleteDocument(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.PUBLICATOR
	 */
	public int getLevel() {
		return ISecurityManager.PUBLICATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("DeleteDocument::action()");
		
		// Rcupration paramtres
		String id = runtimeData.getParameter("id");
		
		// Tentative d'accs sans paramtres
		if(id == null) {
			log(Priority.ERROR, "DeleteDocument::action() : Erreur d'accs  la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataReadManager data = DataFactory.makeRead();
		
		Folder dossier = null;
		Document doc = null;
		// Rcupration du dossier
		try {
			dossier = data.getFolder(folderid, false);
			doc = data.getDocument(intranet, id);
		}
		catch(DataException e) {
			log(Priority.ERROR, "DeleteDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur lors de la suppression du document"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Vrification accs
		if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			log(Priority.ERROR, "DeleteDocument::action() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Vrification verrouillage
		if(doc.isLocked()) {
			log(Priority.ERROR, "DeleteDocument::action() : Suppression d'un document verrouill");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de supprimer un document verrouill"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataWriteManager
		IDataWriteManager data2 = DataFactory.makeWrite();
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		// Suppression du document
		try {
			data2.removeDocument(doc);
			if(doc.getType() == Document.FILE) {
				store.destroyDocument(intranet, doc);
			}
			data2.commit();
		}
		catch(DataException e) {
			log(Priority.ERROR, "DeleteDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		catch(StorageException e) {
			log(Priority.ERROR, "DeleteDocument::action() : " + e);
			log(Priority.FATAL, "DeleteDocument::action() : Le document " + id + " a t supprim de la base mais pas du systme de stockage");
			data2.rollback();
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Redirection
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
