package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataReadManager;
import org.esupportail.portal.channels.CIntranet.data.IDataWriteManager;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * DeleteFolder<br>
 * <br>
 * Cette action prend en charge la suppression d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class DeleteFolder extends IntranetAction {

	private Folder dossier = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public DeleteFolder(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return  Boolean.FALSE (pas d'affichage) 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("DeleteFolder::action()");
		
		// Rcupration IDataReadManager
		IDataReadManager data = DataFactory.makeRead();

		// Rcupration Dossier
		try {
			log("DeleteFolder::action() : data.getFolder()");
			dossier = data.getFolder(folderid, false);
		}
		catch(DataException e) {
			log(Priority.ERROR, "DeleteFolder::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Vrification racine
		if(dossier.isRoot()) {
			log(Priority.ERROR, "DeleteFolder::action() : Tentative de suppression de la racine");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous ne pouvez pas supprimer la racine d'un intranet"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataWriteManager
		IDataWriteManager data2 = DataFactory.makeWrite();
		
		// Suppression du dossier
		try {
			data2.removeFolder(folderid);
		}
		catch(DataException e) {
			log(Priority.ERROR, "DeleteFolder::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Dossier supprim
		runtimeData.setParameter("folderid", dossier.getParent());
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
