package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Mime;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataReadManager;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;

/**
 * Download<br>
 * <br>
 * Cette action prend en charge le tlchargement d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class Download extends IntranetAction implements IMimeResponse {

	private String name = null;
	private String mime = null;
	private InputStream in = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public Download(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.USER
	 */
	public int getLevel() {
		return ISecurityManager.USER;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return  Boolean.FALSE (pas d'affichage) 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("Download::action()");
		
		// Rcupration paramtres
		String id = runtimeData.getParameter("id");
		
		// Tentative d'accs sans paramtre
		if(id == null) {
			log(Priority.ERROR, "Download::action() : Erreur d'accs  la page");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataReadManager data = DataFactory.makeRead();
		
		// Rcupration document, ressource et types MIME
		Document doc = null;
		Collection mimes = null;
		try {
			doc = data.getDocument(intranet, id);
			mimes = data.getMIMEs();
		}
		catch(DataException e) {
			log(Priority.ERROR, "Download::action() : "  + e);
			return Boolean.FALSE;
		}
		
		// Rcupration informations fichier / MIME
		name = doc.getFile();
		Iterator i = mimes.iterator();
		while(i.hasNext()) {
			Mime tmp = (Mime)i.next();
			if(tmp.getExtension().equals(doc.getExtension())) {
				mime = tmp.getType();
			}
		}
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		// Rcupration InputStream
		try {
			in = store.loadDocument(intranet, doc);
		}
		catch(StorageException e) {
			log(Priority.ERROR, "Download::action() : " + e);
		}
		return Boolean.FALSE;
	}

	/**
	 * Retourne le type MIME du document
	 * @return Le type MIME
	 */
	public String getContentType() {
		return mime;
	}

	/**
	 * Retourne un InputStream correspondant au fichier  tlcharger
	 * @return Le flux de donnes
	 */
	public InputStream getInputStream() throws IOException {
		return in;
	}

	/**
	 * Mthode non utilise
	 * @param out Un OutputStream vers le navigateur du client
	 */
	public void downloadData(OutputStream out) throws IOException {
	}

	/**
	 * Retourne le nom du fichier
	 * @return Le nom du fichier
	 */
	public String getName() {
		String result = null;
		result = name.replaceAll(" ", "_");
		result = result.replaceAll("[]", "a");
		result = result.replaceAll("[]", "e");
		result = result.replaceAll("[]", "i");
		result = result.replaceAll("[]", "o");
		result = result.replaceAll("[]", "u");
		result = result.replaceAll("", "c");
		result = result.replaceAll("", "n");
		result = result.replaceAll("[]", "A");
		result = result.replaceAll("[]", "E");
		result = result.replaceAll("[]", "I");
		result = result.replaceAll("[]", "O");
		result = result.replaceAll("[]", "U");
		result = result.replaceAll("", "C");
		result = result.replaceAll("", "N");
		return result;
		//return name;
	}

	/**
	 * Retourne la liste des headers HTTP  envoyer au navigateur
	 * @return La liste des headers
	 */
	public Map getHeaders() {
		HashMap map = new HashMap();
		map.put("Content-disposition", "attachment; filename=" + getName());
		return map;
	}

	/**
	 * Mthode appele si une erreur se produit durant le tlchargement
	 * @param e L'exception leve
	 */
	public void reportDownloadError(Exception e) {
		log(Priority.FATAL, "Download::reportingDownloadError() : " + e);
	}
}
