package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataReadManager;
import org.esupportail.portal.channels.CIntranet.data.IDataWriteManager;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ModifyFolder<br>
 * <br>
 * Cette action prend en charge la modification d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class ModifyFolder extends IntranetAction {

	private Folder dossier = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ModifyFolder(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}

	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("ModifyFolder::action()");
		
		// Rcupration IDataReadManager
		IDataReadManager data = DataFactory.makeRead();
		
		// Rcupration dossier
		try {
			dossier = data.getFolder(folderid, true);
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyFolder::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Vrification racine
		if(dossier.isRoot()) {
			log(Priority.ERROR, "ModifyFolder::action() : Modification du dossier racine");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de modifier le dossier racine"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche le formulaire de modification de dossier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		xml = dossier.toXMLString();
		return Boolean.TRUE;
	}
	
	/**
	 * Modification du dossier
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean modifyinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log("ModifyFolder::modifyinit()");
		runtimeData = rd;
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ModifyFolder::modifyinit() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("button");
	
		// Tentative d'accs sans bouton
		if(button == null) {
			button = "Valider";
		}
		
		// Clic sur le bouton Annuler
		if(!button.equals("Valider")) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String name = runtimeData.getParameter("name");
		String validation = runtimeData.getParameter("valid");
		
		// Tentative d'accs sans paramtres
		if(name == null || name.equals("")) {
			log(Priority.ERROR, "ModifyFolder::modifyinit() : Erreur d'accs  la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "default");		
			return Boolean.FALSE;
		}
		
		boolean valid = false;
		if(validation != null) {
			valid = true;
		}
		
		// Test si modifications
		if(valid == dossier.isValidation() && name.equals(dossier.getName())) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Modification de la validation
		if(valid != dossier.isValidation()) {
			if(dossier.getDocuments().iterator().hasNext() || dossier.getSubFolders().iterator().hasNext()) {
				// Changement de validation sur un dossier non vide
				log(Priority.ERROR, "ModifyFolder::modifyinit()");
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean("Impossible de changer la validation sur un dossier non vide"), "modifyfold", parameters);
				return Boolean.FALSE;
			}
			else {
				dossier.setValidation(valid);
			}
		}
		
		// Modification du nom
		if(!name.equals(dossier.getName())) {
			dossier.setName(name);
		}
		
		// Rcupration IDataWriteManager
		IDataWriteManager data = DataFactory.makeWrite();
		
		try {
			data.updateFolder(dossier);
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyFolder::modifyinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
