package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Collection;
import java.util.Iterator;

/**
 * Path<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives au chemin d'un dossier<br>
 * En ralit, cette classe conserve la liste des dossiers traverss depuis la racine<br>
 * jusqu'au dossier courant<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class Path {

	private Collection path = null;

	/**
	 * Constructeur
	 * @param path
	 */
	public Path(Collection path) {
		this.path = path;
	}

	/**
	 * Le chemin du dossier
	 * @param path
	 */
	public void setPath(Collection path) {
		this.path = path;
	}

	/**
	 * Le chemin du dossier
	 * @return
	 */
	public Collection getPath() {
		return path;
	}

	/**
	 * La reprsentation XML de ce chemin
	 * @return
	 */
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();
		xml.append("<path>\n");
		Iterator i = path.iterator();
		while(i.hasNext()) {
			SubFolder tmp = (SubFolder)i.next();
			xml.append(tmp.toXMLString());
		}
		xml.append("</path>\n");
		return xml.toString();
	}
}