package org.esupportail.portal.channels.CIntranet.config;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.utils.channels.ConfigChannel;
import org.jasig.portal.services.LogService;

/**
 * Config<br>
 * <br>
 * Classe implmentant un mcanisme de singleton permettant la lecture du fichier<br>
 * de configuration du canal Intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.3
 * 
 */

public class Config extends ConfigChannel implements IntranetConfig, SizeLimiter {

	private static Config singleton = null;
	private String dataReadManager;
	private String dataWriteManager;
	private String groupManager;
	private String securityManager;
	private Hashtable storageControlers;
	private String sizeUpload;
	private String annuaires;

	/**
	 * Rcupration du singleton
	 * @return
	 */
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	/**
	 * Le fichier de configuration
	 * @return
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CIntranet/CIntranet.xml";
	}
	
	/**
	 * Mthode permettant la lecture de la partie spcifique<br>
	 * au canal Intranet du fichier de configuration
	 */
	protected void customDigester() {
		LogService.log(Priority.DEBUG, "Config::customDigester()");
		// Implmentation du IDataReadManager
		dig.addCallMethod("config/dataReadManager", "setDataReadManager", 1);
		dig.addCallParam("config/dataReadManager", 0, "classname");
		
		// Implmentation du IDataWriteManager
		dig.addCallMethod("config/dataWriteManager", "setDataWriteManager", 1);
		dig.addCallParam("config/dataWriteManager", 0, "classname");
		
		// Implmentation du IGroupManager
		dig.addCallMethod("config/groupManager", "setGroupManager", 1);
		dig.addCallParam("config/groupManager", 0, "classname");
		
		// Implmentation du ISecurityManager
		dig.addCallMethod("config/securityManager", "setSecurityManager", 1);
		dig.addCallParam("config/securityManager", 0, "classname");
		
		// Ressources
		
		storageControlers = new Hashtable();
		
		dig.addObjectCreate("config/storageControler", Ressource.class);
		dig.addSetProperties("config/storageControler");
		
			dig.addCallMethod("config/storageControler/parameters/parameter", "addParameter", 2);
			dig.addCallParam("config/storageControler/parameters/parameter", 0, "name");
			dig.addCallParam("config/storageControler/parameters/parameter", 1, "value");
		
		dig.addSetNext("config/storageControler", "addRessource");
		
		dig.addCallMethod("config/annuaires", "setAnnuaires", 1);
		dig.addCallParam("config/annuaires", 0, "list");
		
		dig.addCallMethod("config/fileupload", "setSizeUpload", 1);
		dig.addCallParam("config/fileupload", 0, "size");
	}

	/**
	 * La classe d'implmentation du IDataReadManager
	 * @param classname
	 */
	public void setDataReadManager(String classname) {
		LogService.log(
			Priority.DEBUG,
			"Config::setDataReadManager() : classname = " + classname);
		dataReadManager = classname;
	}

	/**
	 * La classe d'implmentation du IDataReadManager
	 * @return
	 */
	public String getDataReadManager() {
		LogService.log(Priority.DEBUG, "Config::getDataReadManager() : "
			+ dataReadManager);
		return dataReadManager;
	}
	
	/**
	 * La classe d'implmentation du IDataWriteManager
	 * @param classname
	 */
	public void setDataWriteManager(String classname) {
		LogService.log(
			Priority.DEBUG,
			"Config::setDataWriteManager() : classname = " + classname);
		dataWriteManager = classname;
	}

	/**
	 * La classe d'implmentation du IDataWriteManager
	 * @return
	 */
	public String getDataWriteManager() {
		LogService.log(Priority.DEBUG, "Config::getDataWriteManager() : "
			+ dataReadManager);
		return dataWriteManager;
	}

	/**
	 * La classe d'implmentation du IGroupManager
	 * @param classname
	 */
	public void setGroupManager(String classname) {
		LogService.log(
			Priority.DEBUG,
			"Config::setGroupManager() : classname = " + classname);
		groupManager = classname;
	}

	/**
	 * La classe d'implmentation du IGroupManager
	 * @return
	 */
	public String getGroupManager() {
		LogService.log(Priority.DEBUG, "Config::getGroupManager()");
		return groupManager;
	}

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @param classname
	 */
	public void setSecurityManager(String classname) {
		LogService.log(
			Priority.DEBUG,
			"Config::setSecurityManager() : classname = " + classname);
		securityManager = classname;
	}

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @return
	 */
	public String getSecurityManager() {
		LogService.log(Priority.DEBUG, "Config::getSecurityManager()");
		return securityManager;
	}


	/**
	 * Ajout d'une ressource physique de stockage
	 * @param res
	 */
	public void addRessource(Ressource res) {
		LogService.log(Priority.DEBUG, "Config::addRessource() : " + res.getName() + " " + res.getClassname());
		storageControlers.put(res.getName(), res);
	}
	
	/**
	 * La liste des ressources physiques de stockage
	 * @return
	 */
	public Hashtable getRessources() {
		LogService.log(Priority.DEBUG, "Config::getRessources()");
		return storageControlers;
	}

	/**
	 * La taille limite des fichiers uploads en octets
	 * @param size
	 */
	public void setSizeUpload(String size) {
		sizeUpload = size;
	}

	/**
	 * La taille limite des fichiers uploads en octets
	 * @return
	 */
	public int getSizeUpload() {
		return new Integer(sizeUpload).intValue();
	}

	/**
	 * La liste des annuaires  utiliser
	 * @return
	 */
	public String getAnnuaires() {
	    return annuaires;
	}
	
	/**
	 * La liste des annuaires  utiliser
	 * @param liste
	 */
	public void setAnnuaires(String liste) {
	    annuaires = liste;
	}
}
