package org.esupportail.portal.channels.CIntranet.data;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.Mime;
import org.esupportail.portal.channels.CIntranet.beans.Population;

/**
 * IDataWriteManager<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * le gestionnaire de donnes pour l'criture<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.3
 */


public interface IDataWriteManager {
	
	/************************************************************
	 *	Intranets												* 
	 ************************************************************/
	
	/**
	 * Cration d'un intranet
	 * @param intranet L'intranet  crer
	 */
	public void createIntranet(Intranet intranet) throws DataException;
	
	/**
	 * Suppression d'un intranet
	 * @param intranet L'intranet  supprimer
	 * @throws DataException
	 */
	public void removeIntranet(Intranet intranet) throws DataException;
	
	
	/************************************************************
	 *	Populations												* 
	 ************************************************************/
	
	/**
	 * Ajout d'une population
	 * @param population La population  ajouter
	 */
	public void addPopulation(Population population) throws DataException;
	
	/**
	 * Suppression d'une population
	 * @param intranet L'identifiant de l'intranet dont on souhaite supprimer la population
	 * @throws DataException
	 */
	public void removePopulation(String intranet) throws DataException;
	
	
	/************************************************************
	 *	Super Utilisateurs										* 
	 ************************************************************/
	
	/**
	 * Ajout d'un super-utilisateur
	 * @param login L'identifiant de l'utilisateur
	 */
	public void addSuperUser(String login) throws DataException;
	
	/**
	 * Suppression d'un super-utilisateur
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
	public void removeSuperUser(String login) throws DataException;

	
	/************************************************************
	 *	Dossiers												* 
	 ************************************************************/
	
	/**
	 * Cration d'un dossier
	 * @param folder Le dossier  crer
	 * @return L'identifiant du dossier cr
	 */
	public String createFolder(Folder folder) throws DataException;
	
	/**
	 * Suppression d'un dossier
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
	public void removeFolder(String id) throws DataException;
	
	/**
	 * Mise  jour d'un dossier
	 * @param folder L'identifiant du dossier
	 * @throws DataException
	 */
	public void updateFolder(Folder folder) throws DataException;
	
	
	/************************************************************
	 *	Documents												* 
	 ************************************************************/
	
	/**
	 * Cration d'un document
	 * @param doc Le document  crer
	 * @param valid Si le document est valide true, false sinon
	 */
	public void createDocument(Document doc, boolean valid) throws DataException;
	
	/**
	 * Suppression d'un document
	 * @param doc Le document  supprimer
	 * @throws DataException
	 */
	public void removeDocument(Document doc) throws DataException;
	
	/**
	 * Mise  jour d'un document
	 * @param doc Le document  mettre  jour
	 * @throws DataException
	 */
	public void updateDocument(Document doc) throws DataException;
	
	/**
	 * Validation d'un document
	 * @param doc Le document  valider
	 * @throws DataException
	 */
	public void validDocument(Document doc) throws DataException;
	
	
	/************************************************************
	 *	Types MIME												* 
	 ************************************************************/
	
	/**
	 * Cration d'un type MIME
	 * @param mime Le type MIME  crer
	 */
	public void createMIME(Mime mime) throws DataException;
	
	/**
	 * Suppression d'un type MIME
	 * @param extension L'extension associe au type MIME
	 * @throws DataException
	 */
	public void removeMIME(String extension) throws DataException;

	
	/************************************************************
	 *	Valideurs												* 
	 ************************************************************/
	
	/**
	 * Ajout d'un valideur
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @param notification Si l'utilisateur souhaite tre notifi true, false sinon
	 * @param propagation Si ce valideur doit tre propag aux sous-dossiers true, false sinon
	 */
	public void addValidator(String id, String login, boolean notification, boolean propagation) throws DataException;
	
	/**
	 * Suppression d'un valideur
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @param propagation Si le valideur doit tre supprim des sous-dossiers true, false sinon
	 * @throws DataException
	 */
	public void removeValidator(String id, String login, boolean propagation) throws DataException;
	
	/**
	 * Suppression de tous les valideurs d'un dossier
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
	public void removeAllValidators(String id) throws DataException;
	
	
	/************************************************************
	 *	Publicateurs											* 
	 ************************************************************/
	
	/**
	 * Ajout d'un publicateur
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 */
	public void addPublicator(String id, String login, boolean propagation) throws DataException;
	
	/**
	 * Ajout d'un groupe de publicateurs
	 * @param id L'identifiant du dossier
	 * @param group L'identifiant du groupe
	 * @throws DataException
	 */
	public void addPublicators(String id, String group, boolean propagation) throws DataException;
	
	/**
	 * Suppression d'un publicateur
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
	public void removePublicator(String id, String login, boolean propagation) throws DataException;
	
	/**
	 * Suppression d'un groupe de publicateurs
	 * @param id L'identifiant du dossier
	 * @param group L'identifiant du groupe
	 * @throws DataException
	 */
	public void removePublicators(String id, String group, boolean propagation) throws DataException;
	
	/**
	 * Suppression de tous les publicateurs d'un dossier
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
	public void removeAllPublicators(String id) throws DataException;
	
	
	/************************************************************
	 *	Transactions											* 
	 ************************************************************/
	
	/**
	 * Valide les modifications
	 */
	public void commit();
	
	/**
	 * Annule les modifications
	 */
	public void rollback();
}
