package org.esupportail.portal.channels.CIntranet.groups;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.jasig.portal.services.LogService;

/**
 * GroupFactory<br>
 * <br>
 * Fabrique de IGroupManager<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class GroupFactory {
	
	private static Priority nivlog = Priority.DEBUG;
	private static IGroupManager singleton = null;
	
	/**
	 * Construit un IGroupManager et implmente un mcanisme<br>
	 * de singleton
	 * @return L'implmentation du IGroupManager correspondante
	 */
	public static IGroupManager make() {
		if(singleton != null) {
			return singleton;
		}
		
		Class groupManagerClass = null;
		Object groupManagerObject = null;
		IGroupManager res = null;
		String classname = Config.getInstance().getGroupManager();
		if(classname == null) {
			LogService.log(Priority.ERROR, "GroupFactory::make() : classname null");
			return res;
		}
		
		try {
			LogService.log(nivlog, "GroupFactory::make() : Tentative d'instanciation du GroupManager " + classname);
			groupManagerClass = Class.forName(classname);
			groupManagerObject = groupManagerClass.newInstance();
			res = (IGroupManager)groupManagerObject;
		}
		catch(Exception e) {
			res = null;
			LogService.log(Priority.ERROR, "GroupFactory::make() : Echec de l'instanciation du GroupManager " + classname);
			LogService.log(Priority.ERROR, "GroupFactory::make() : Exception " + e);
		}
		singleton = res;
		return singleton;
	}
}
