package org.esupportail.portal.channels.CIntranet.security;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.jasig.portal.services.LogService;

/**
 * SecurityFactory<br>
 * <br>
 * Fabrique de ISecurityManager<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class SecurityFactory {
	
	private static Priority nivlog = Priority.DEBUG;
	private static ISecurityManager singleton = null;
	
	/**
	 * Construit un ISecurityManager et implmente un mcanisme<br>
	 * de singleton
	 * @return L'implmentation du ISecurityManager correspondante
	 */
	public static ISecurityManager make() {
		if(singleton != null) {
			return singleton;
		}
		
		Class securityManagerClass = null;
		Object securityManagerObject = null;
		ISecurityManager res = null;
		String classname = Config.getInstance().getSecurityManager();
		
		if(classname == null) {
			LogService.log(Priority.ERROR, "SecurityFactory::make() : classname null");
			return res;
		}
		
		try {
			LogService.log(nivlog, "SecurityFactory::make() : Tentative d'instanciation du SecurityManager " + classname);
			securityManagerClass = Class.forName(classname);
			securityManagerObject = securityManagerClass.newInstance();
			res = (ISecurityManager)securityManagerObject;
		}
		catch(Exception e) {
			res = null;
			LogService.log(Priority.ERROR, "SecurityFactory::make() : Echec de l'instanciation du SecurityManager " + classname);
			LogService.log(Priority.ERROR, "SecurityFactory::make() : Exception " + e);
		}
		singleton = res;
		return singleton;
	}
}
