package org.esupportail.portal.channels.CIntranet.utils;

import java.text.SimpleDateFormat;

/**
 * Date<br>
 * <br>
 * Classe permettant de manipuler des dates<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class Date {
	
	private static String [] mois = {"janvier", "fvrier", "mars", "avril", "mai", "juin", "juillet", "aot", "septembre", "octobre", "novembre", "dcembre"};
	
	/**
	 * Mise en forme d'une date YYYYMMDD sous la forme franaise
	 * @param date La date  formater
	 * @return la date formate
	 */
	public static String formatDate(String date) {
		String annee = date.substring(0,4);
		String moi = mois[new Integer(date.substring(4,6)).intValue() - 1];
		String jour = date.substring(6);
		return jour + " " + moi + " " + annee;
	}
	
	/**
	 * Retourne la date courante au format YYYYMMDD
	 * @return
	 */
	public static String getCurrentDate() {
		return new SimpleDateFormat("yyyyMMdd").format(new java.util.Date());
	}
}
