<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}highlight.js" >
</script>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="5">
		<tr class="uportal-background-light">
			
			<!-- Affichage Actualiser -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=defaultadmin">
					<img src="{$mediaPath}refresh.gif" border="0" alt="Actualiser"/>
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=defaultadmin">Actualiser</a>
			</td>
			
			<!-- Affichage Nouvel Intranet -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=newintranet">
					<img src="{$mediaPath}newdoc.gif" border="0" alt="Nouvel Intranet"/>
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=newintranet">Nouvel Intranet</a>
			</td>
			
			<!-- Affichage Types MIME -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=mimes">
					<img src="{$mediaPath}mimes.gif" border="0" alt="Extensions"/>
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=mimes">Extensions</a>
			</td>
			
			<!-- Affichage Super Utilisateurs -->
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=su">
					<img src="{$mediaPath}su.gif" border="0" alt="Super Utilisateurs"/>
				</a>
			</td>
			<td class="uportal-label" nowrap="true">
				<a href="{$baseActionURL}?action=su">Super Utilisateurs</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
		
	<br/>
	
	<!-- Affichage des intranets -->
	<xsl:apply-templates select="intranets" />

</xsl:template>

<!-- Affichage des intranets -->
<xsl:template match="intranets">
	
	<xsl:if test="count(intranet)!=0">
		<br/>
		<table border="0" width="100%" cellpadding="1" cellspacing="0">
			<!-- Affichage des intranets -->
				<xsl:apply-templates select="intranet" />
		</table>			
	</xsl:if>
	
</xsl:template>

<!-- Affichage des options d'intranet -->
<xsl:template match="intranet">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');">
	
	<!-- Icone suppression -->
	<td align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=deleteintranet&amp;id={./@id}">
			<img src="{$mediaPath}deletefold.gif" border="0" alt="Supprimer" />
		</a>
	</td>
	
	<!-- Icone population -->
	<td align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=population&amp;id={./@id}">
			<img src="{$mediaPath}permissions.gif" border="0" alt="Population" />
		</a>
	</td>
	
	<td width="5%">&#160;</td>
	
	<!-- Affichage Intranet -->
	<td class="uportal-label" nowrap="true">
		<xsl:value-of select="./@name" />
	</td>
	
	<td width="5%">&#160;</td>
	
	<!-- Affichage Ressource -->
	<td class="uportal-text-small" nowrap="true">
		<xsl:value-of select="./@ressource" />
	</td>
	
	<td width="100%">&#160;</td>
	</tr>
</xsl:template>	
			
</xsl:stylesheet>