<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="superuser" />
<xsl:param name="all" />

<xsl:template match="xml">
	
	<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr class="uportal-background-light">
		<td class="uportal-channel-table-header" nowrap="true">Liste des Intranets</td>
		
		<xsl:if test="$superuser='true'" >
			<xsl:choose>
				<xsl:when test="$all='true'">
					<td class="uportal-label" nowrap="true">
						<a href="{$baseActionURL}?action=default&amp;all=false">
							Intranets accessibles
						</a>
					</td>
				</xsl:when>
				<xsl:when test="$all='false'">
					<td class="uportal-label" nowrap="true">
						<a href="{$baseActionURL}?action=default&amp;all=true">
							Tous les intranets
						</a>
					</td>				
				</xsl:when>			
			</xsl:choose>
		</xsl:if>
		
		<td width="100%">&#160;</td>
	</tr>
	</table>
	<br/>
	
	<xsl:choose>
		<xsl:when test="count(intranet)=0">
			<tr>
				<td class="uportal-channel-error">Aucun intranet accessible</td>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<table border="0" width="100%" cellspacing="0" cellpadding="5">
				<xsl:apply-templates select="intranet" />
			</table>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="intranet">
	<tr>
		<td class="uportal-label">
			<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@root}&amp;intranet={./@id}&amp;ressource={./@ressource}">
				<xsl:value-of select="./@name" />
			</a>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>