<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<!--<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />-->




<!--#####################################################-->
<!--                                                     -->                       
<!--                    Barre d'outils                   -->
<!--                                                     -->
<!--#####################################################-->


<!-- Bouton actualiser -->
<xsl:template name="outil.actualiser">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}">
		<img src="{$mediaPath}refresh.gif" border="0" alt="Actualiser"/>
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}">Actualiser</a>
</td>

</xsl:template>

<!-- Bouton nouveau document -->
<xsl:template name="outil.nouveau.document">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=newdocument&amp;folderid={./@id}">
		<img src="{$mediaPath}newdoc.gif" border="0" alt="Nouveau Document"/>
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=newdocument&amp;folderid={./@id}">Nouveau document</a>
</td>
	
</xsl:template>

<!-- Bouton nouveau dossier -->
<xsl:template name="outil.nouveau.dossier">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=newfolder&amp;folderid={./@id}">
		<img src="{$mediaPath}newfolder.gif" border="0" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=newfolder&amp;folderid={./@id}">Nouveau dossier</a>
</td>

</xsl:template>

<!-- Bouton suppression dossier -->
<xsl:template name="outil.suppression.dossier">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=deletefold&amp;folderid={./@id}" onclick="return confirm('Etes-vous sur de supprimer le dossier courant ?');">
		<img src="{$mediaPath}deletefold.gif" border="0" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=deletefold&amp;folderid={./@id}" onclick="return confirm('Etes-vous sur de supprimer le dossier courant ?');">Supprimer</a>
</td>

</xsl:template>

<!-- Bouton modification dossier -->
<xsl:template name="outil.modification.dossier">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=modifyfold&amp;folderid={./@id}">
		<img src="{$mediaPath}modify_on.gif" border="0" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=modifyfold&amp;folderid={./@id}">Modifier</a>
</td>

</xsl:template>

<!-- Bouton permissions -->
<xsl:template name="outil.permissions">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=permissions&amp;folderid={./@id}">
		<img src="{$mediaPath}permissions.gif" border="0" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=permissions&amp;folderid={./@id}">Permissions</a>
</td>

</xsl:template>

<!-- Bouton intranets -->
<xsl:template name="outil.intranets">

<td valign="absmiddle">
	<a href="{$baseActionURL}?action=default">
		<img src="{$mediaPath}listintranets.gif" border="0" />
	</a>
</td>
<td class="uportal-label" nowrap="true">
	<a href="{$baseActionURL}?action=default">Intranets</a>
</td>

</xsl:template>



<!--#####################################################-->
<!--                                                     -->                       
<!--            Chemin et sous dossiers                  -->
<!--                                                     -->
<!--#####################################################-->


<!-- Affichage du chemin -->
<xsl:template match="path/subfolder">
	<td class="uportal-channel-table-header" nowrap="true">
		<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}&amp;">
			<xsl:value-of select="./@name" />
		</a>&#160;&#62;
	</td>
</xsl:template>

<!-- Affichage des sous-dossiers -->
<xsl:template match="subfolders">
	<xsl:if test="count(subfolder)!=0">
		<br/>		
		<table border="0">
			<!-- Affichage des sous-dossiers -->
			<xsl:apply-templates select="subfolder" />
		</table>
	</xsl:if>
</xsl:template>

<!-- Affichage des sous-dossiers -->
<xsl:template match="subfolder">
	<tr>
		<td valign="absmiddle">
			<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}">
				<img src="{$mediaPath}folder.gif" border="0" />
			</a>
		</td>
		<td class="uportal-label">
			<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}">
				<xsl:value-of select="./@name" />
			</a>
		</td>
	</tr>
</xsl:template>



<!--#####################################################-->
<!--                                                     -->                       
<!--                      Icnes                         -->
<!--                                                     -->
<!--#####################################################-->


<!-- Checkbox -->
<xsl:template name="icon.checkbox">
	<td>
		<input type="checkbox" name="id" value="{./@id}" />
	</td>
</xsl:template>

<!-- Pas de checkbox -->
<xsl:template name="icon.nocheckbox">
	<td>&#160;</td>
</xsl:template>

<!-- Zoom -->
<xsl:template name="icon.zoom">
	<td align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=viewdoc&amp;id={./@id}&amp;folderid={/xml/folder/@id}">
			<img src="{$mediaPath}zoom.gif" border="0" alt="Informations" />
		</a>
	</td>
</xsl:template>

<!-- Modification -->
<xsl:template name="icon.modify">
	<td align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=modifydoc&amp;id={./@id}&amp;folderid={/xml/folder/@id}">
			<img src="{$mediaPath}modify_on.gif" border="0" alt="Modifier" />
		</a>
	</td>
</xsl:template>

<!-- Pas de modification -->
<xsl:template name="icon.nomodify">
	<td>&#160;</td>
</xsl:template>

<!-- En cours de modification -->
<xsl:template name="icon.modified">
	<td align="center" valign="absmiddle">
		<img src="{$mediaPath}modif.gif" border="0" alt="Modifications" />
	</td>
</xsl:template>

<!-- Nouveau -->
<xsl:template name="icon.new">
	<td align="center" valign="absmiddle">
		<img src="{$mediaPath}new.gif" border="0" alt="Modifications" />
	</td>
</xsl:template>

<!-- Verrouill -->
<xsl:template name="icon.locked">
	<td align="center" valign="absmiddle">
		<img src="{$mediaPath}locked.gif" border="0" alt="Verrouill" />
	</td>
</xsl:template>

<!-- Suppression -->
<xsl:template name="icon.delete">
	<td align="center" valign="absmiddle">
		<a href="{$baseActionURL}?action=deletedoc&amp;id={./@id}&amp;folderid={/xml/folder/@id}" onclick="return confirm('Etes-vous sur de supprimer ce document ?');">
			<img src="{$mediaPath}deletedoc.gif" border="0" alt="Supprimer" />
		</a>
	</td>
</xsl:template>

<!-- Pas de suppression -->
<xsl:template name="icon.nodelete">
	<td>&#160;</td>
</xsl:template>



<!--#####################################################-->
<!--                                                     -->                       
<!--                    Documents                        -->
<!--                                                     -->
<!--#####################################################-->


<xsl:template name="document.fichier">
	<xsl:choose>
		<xsl:when test="./@ext='.doc'">
			<td valign="absmiddle"><img src="{$mediaPath}docdoc.gif" border="0" /></td>
		</xsl:when>
		<xsl:when test="./@ext='.xls'">
			<td valign="absmiddle"><img src="{$mediaPath}docxls.gif" border="0" /></td>
		</xsl:when>
		<xsl:when test="./@ext='.ppt'">
			<td valign="absmiddle"><img src="{$mediaPath}docppt.gif" border="0" /></td>
		</xsl:when>
		<xsl:when test="./@ext='.htm' or ./@ext='.html'">
			<td valign="absmiddle"><img src="{$mediaPath}dochtm.gif" border="0" /></td>
		</xsl:when>
		<xsl:when test="./@ext='.pdf'">
			<td valign="absmiddle"><img src="{$mediaPath}docpdf.gif" border="0" /></td>
		</xsl:when>
		<xsl:when test="./@ext='.zip' or ./@ext='.tar' or ./@ext='.rar' or ./@ext='.gz'">
			<td valign="absmiddle"><img src="{$mediaPath}doczip.gif" border="0" /></td>
		</xsl:when>
		<xsl:otherwise>
			<td valign="absmiddle"><img src="{$mediaPath}docstd.gif" border="0" /></td>
		</xsl:otherwise>
		
	</xsl:choose>
	
	<td class="uportal-label" nowrap="true">
		<a href="{$baseDownloadURL}?action=download&amp;folderid={/xml/folder/@id}&amp;id={./@id}">
			<xsl:value-of select="./@name" />
		</a>
	</td>
	<td width="3%">&#160;</td>
	<td class="uportal-text-small" nowrap="true">
		<xsl:value-of select="./@description" />
	</td>
</xsl:template>

<!-- Affichage d'un lien -->
<xsl:template name="document.lien">
	<td valign="absmiddle"><img src="{$mediaPath}dochtm.gif" border="0" /></td>
	<td class="uportal-label" nowrap="true">
		<a href="{./@file}" target="_blank">
			<xsl:value-of select="./@name" />
		</a>
	</td>
	<td width="3%">&#160;</td>
	<td class="uportal-text-small" nowrap="true">
		<xsl:value-of select="./@description" />
	</td>
</xsl:template>

</xsl:stylesheet>