package org.esupportail.portal.channels.CIntranet.actions.admin;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.security.SecurityFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * AdminAction<br>
 * <br>
 * Classe abstraite dfinissant un comportement par dfaut pour une action<br>
 * L'accs  cette action ncessite un statut de super-utilisateur<br>
 * sinon on redirige vers une page d'erreur<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */

public abstract class AdminAction extends SubChannel {

	protected String login = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public AdminAction(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Mthode vrifiant si l'utilisateur courant est un super-utilisateur
	 * @param rd
	 * @return Boolean.FALSE si pas super-utilisateur, action() sinon
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log("AdminAction::init()");
		runtimeData = rd;
		
		// Rcupration paramtres statiques
		login = mainChannel.getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
		
		// Vrification paramtres
		if(login == null) {
			log(Priority.ERROR, "AdminAction::init() : login = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "defaultadmin");
			return Boolean.FALSE;
		}
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		
		// Vrification accs
		boolean superuser = false;
		try {
			log("AdminAction::init() : security.isSuperUser()");
			superuser = security.isSuperUser(login);
			if(!superuser) {
				log(Priority.ERROR, "AdminAction::init() : Accs refus pour " + login);
				Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  accder  cette page"), "defaultadmin");
				return Boolean.FALSE;
			}
		}
		catch(SecurityException e) {
			log(Priority.ERROR, "AdminAction::init() : SecurityException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()));
			return Boolean.FALSE;
		}
		
		// Transfert  la classe d'implmentation
		return action();
	}
	
	/**
	 * Mthode abstraite implmentant le comportement de l'action si l'utilisateur<br>
	 * est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public abstract Boolean action() throws PortalException, FrameWorkException;
}
