package org.esupportail.portal.channels.CIntranet.actions.admin;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataReadManager;
import org.esupportail.portal.channels.CIntranet.data.IDataWriteManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * DeleteIntranet<br>
 * <br>
 * Cette action prend en charge la suppression d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */
public class DeleteIntranet extends AdminAction {

    private String id = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public DeleteIntranet(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("DeleteIntranet::action()");
        
        // Rcupration paramtres
        id = runtimeData.getParameter("id");
        
        // Tentative d'accs sans paramtre
        if(id == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
    
    /**
     *	Affichage de la confirmation de suppression
     *	@return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        log("DeleteIntranet::setXML()");
        return Boolean.TRUE;
    }
    
    
    /**
     * Traite la suppression d'un intranet
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean removeinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("DeleteIntranet::removeinit()");
        
        // Rcupration bouton
        String button = runtimeData.getParameter("butoui");
        
        // Vrification bouton
        if(button == null) {
            mainChannel.redirect(runtimeData, "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataReadManager
        IDataReadManager data2 = DataFactory.makeRead();
        
        // Rcupration Intranet
        Intranet intranet = null;
        try {
            intranet = data2.getIntranet(id);
        }
        catch(DataException e) {
            log(Priority.ERROR, "DeleteIntranet::removeinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataWriteManager
        IDataWriteManager data = DataFactory.makeWrite();
        
        // Rcupration IStorageControler
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        
        // Suppression de l'intranet
        try {
            data.removeIntranet(intranet);
            store.destroyIntranet(id);
            data.commit();
        }
        catch(DataException e) {
            log(Priority.ERROR, "DeleteIntranet::removeinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        catch(StorageException e) {
            log(Priority.ERROR, "DeleteIntranet::removeinit() : " + e);
            data.rollback();
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        
        mainChannel.redirect(runtimeData, "defaultadmin");
        return Boolean.FALSE;
    }
}
