package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataReadManager;
import org.esupportail.portal.channels.CIntranet.data.IDataWriteManager;
import org.esupportail.portal.channels.CIntranet.groups.GroupException;
import org.esupportail.portal.channels.CIntranet.groups.GroupFactory;
import org.esupportail.portal.channels.CIntranet.groups.IGroupManager;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.security.SecurityFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ViewPermissions<br>
 * <br>
 * Cette action prend en charge la visualisation / modification des permissions d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class ViewPermissions extends IntranetAction {

	private Hashtable validators = null;
	private Hashtable users = null;
	private Hashtable groups = null;
	private Hashtable population = null;
	private StringBuffer xml2 = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ViewPermissions(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("ViewPermissions::action()");
		
		validators = new Hashtable();
		users = new Hashtable();
		groups = new Hashtable();
		
		Collection validators = null;
		Collection users = null;
		Collection groups = null;
		
		// Rcupration IDataReadManager
		IDataReadManager data = DataFactory.makeRead();
		
		// Rcupration Valideurs et Publicateurs
		try {
			log("ViewPermissions::action() : data.getValidators() : " + folderid);
			validators = data.getValidators(folderid);
			log("ViewPermissions::action() : data.getUsersPublicators() " + folderid);
			users = data.getUsersPublicators(folderid);
			log("ViewPermissions::action() : data.getGroupsPublicators() " + folderid);
			groups = data.getGroupsPublicators(folderid);
		}
		catch(DataException e) {
			log(Priority.ERROR, "ViewPermissions::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Rcupration GroupManager
		IGroupManager group = GroupFactory.make();
		
		// Rcupration des noms des valideurs
		Iterator i = validators.iterator();
		while(i.hasNext()) {
			String tmp = (String)i.next();
			String name = null;
			try {
				name = group.getUserDisplayName(tmp);
				this.validators.put(tmp, name);
			}
			catch(GroupException e) {
				log(Priority.ERROR, "ViewPermissions::action() : " + e);
			}
		}
		
		// Rcupration des noms des publicateurs
		i = users.iterator();
		while(i.hasNext()) {
			String tmp = (String)i.next();
			String name = null;
			try {
				name = group.getUserDisplayName(tmp);
				this.users.put(tmp, name);
			}
			catch(GroupException e) {
				log(Priority.ERROR, "ViewPermissions::action() : " + e);
			}
		}
		
		// Rcupration des noms des groupes de publicateurs
		i = groups.iterator();
		while(i.hasNext()) {
			String tmp = (String)i.next();
			String name = null;
			try {
				name = group.getGroupDisplayName(tmp);
				this.groups.put(tmp, name);
			}
			catch(GroupException e) {
				log(Priority.ERROR, "ViewPermissions::action() : " + e);
			}
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affichage des permissions pour ce dossier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		log("ViewPermissions::setXML()");
		StringBuffer xml = new StringBuffer();
		xml.append("<validators>\n");
		Iterator i = validators.keySet().iterator();
		while(i.hasNext()) {
			String key = (String)i.next();
			String value = (String)validators.get(key);
			xml.append("<user login=\"" + key + "\" name=\"" + value + "\" />\n");
		}
		xml.append("</validators>\n");
		xml.append("<publicators>\n");
		xml.append("<groups>\n");
		i = groups.keySet().iterator();
		while(i.hasNext()) {
			String key = (String)i.next();
			String value = (String)groups.get(key);
			xml.append("<group id=\"" + key + "\" name=\"" + value + "\" />\n");
		}
		xml.append("</groups>\n");
		xml.append("<users>\n");
		i = users.keySet().iterator();
		while(i.hasNext()) {
			String key = (String)i.next();
			String value = (String)users.get(key);
			xml.append("<user login=\"" + key + "\" name=\"" + value + "\" />\n");
		}
		xml.append("</users>\n");
		xml.append("</publicators>\n");
		this.xml = xml.toString();
		xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}

	/**
	 * Suppression de publicateurs
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean pubinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ViewPermissions::pubinit()");
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ViewPermissions::pubinit()() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butadd");
		
		// Slection bouton
		if(button != null) {
			log("ViewPermissions::pubinit() : redirection canal annuaire");
			mainChannel.redirect(runtimeData, "groupspub");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String [] uids = runtimeData.getParameterValues("uid");
		String [] gids = runtimeData.getParameterValues("gid");
		
		// Vrification paramtres
		if((uids == null || uids.length == 0) && (gids == null || gids.length == 0)) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataWriteManager
		IDataWriteManager data = DataFactory.makeWrite();
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		Vector v = new Vector();
		if(gids != null && gids.length != 0) {
			for(int i=0;i<gids.length;i++) {
				String groupname = null;
				try {
					groupname = group.getGroupDisplayName(gids[i]);
				}
				catch(GroupException e) {
					log(Priority.ERROR, "ViewPermissions::pubinit() : " + e); 
				}	
				if(groupname != null) {
					try {
						data.removePublicators(folderid, gids[i], true);
						v.add(new MessageBean(groupname + " : Groupe supprim", Message.INFO));
					}
					catch(DataException e) {
						log(Priority.ERROR, "ViewPermissions::pubinit() : " + e);
						v.add(new MessageBean(groupname + " : " + e.getMessage(), Message.ERROR));
					}
				}
			}
		}
		
		if(uids != null && uids.length != 0) {
			for(int i=0;i<uids.length;i++) {
				String username = null;
				try {
					username = group.getUserDisplayName(uids[i]);
				}
				catch(GroupException e) {
					log(Priority.ERROR, "ViewPermissions::pubinit() : " + e); 
				}	
				if(username != null) {
					try {
						data.removePublicator(folderid, uids[i], true);
						v.add(new MessageBean(username + " : Publicateur supprim", Message.INFO));
					}
					catch(DataException e) {
						log(Priority.ERROR, "ViewPermissions::pubinit() : " + e);
						v.add(new MessageBean(username + " : " + e.getMessage(), Message.ERROR));
					}
				}
			}
		}
		Hashtable parameters = new Hashtable();
		parameters.put("folderid", folderid);
		Message.message(mainChannel, runtimeData, v, "permissions", parameters);		
		return Boolean.FALSE;
	}
	
	/**
	 * Suppression de valideurs
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean valinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ViewPermissions::valinit()");
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ViewPermissions::valinit()() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butadd");
		
		// Slection bouton
		if(button != null) {
			log("ViewPermissions::valinit() : redirection canal annuaire");
			mainChannel.redirect(runtimeData, "annuaireval");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String [] uids = runtimeData.getParameterValues("uid");
		
		// Vrification paramtres
		if(uids == null || uids.length == 0) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataWriteManager
		IDataWriteManager data = DataFactory.makeWrite();
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		Vector v = new Vector();
		for(int i=0;i<uids.length;i++) {
			String username = null;
			try {
				username = group.getUserDisplayName(uids[i]);
			}
			catch(GroupException e) {
				log(Priority.ERROR, "ViewPermissions::valinit() : " + e); 
			}
			if(username != null) {
				try {
					data.removeValidator(folderid, uids[i], true);
					v.add(new MessageBean(username + " : Valideur supprim", Message.INFO));
				}
				catch(DataException e) {
					log(Priority.ERROR, "ViewPermissions::valinit() : " + e);
					v.add(new MessageBean(username + " : " + e.getMessage(), Message.ERROR));
				}
			}
		}
		
		Hashtable parameters = new Hashtable();
		parameters.put("folderid", folderid);
		Message.message(mainChannel, runtimeData, v, "permissions", parameters);		
		return Boolean.FALSE;
	}

	/**
	 * Ajout de groupes aux publicateurs
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean groupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ViewPermissions::groupinit()");
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ViewPermissions::groupinit()() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataReadManager data = DataFactory.makeRead();
		
		// Rcupration population
		Population population = null;
		try {
			population = data.getPopulation(intranet);
		}
		catch(DataException e) {
			log(Priority.ERROR, "ViewPermissions::valinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		// Rcupration des noms de groupes
		this.population = new Hashtable();
		this.population.put("_EVERYBODY", "Tous les membres");
		Iterator i = population.getGroups().iterator();
		while(i.hasNext()) {
			try {
				String tmp = (String)i.next();
				String name = group.getGroupDisplayName(tmp);
				this.population.put(tmp, name);
			}
			catch(GroupException e) {
				log(Priority.ERROR, "ViewPermissions::valinit() : " + e);
			}
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche la liste des groupes de valideurs disponibles
	 * @return Boolean.TRUE
	 */
	public Boolean groupxml() {
		log("ViewPermissions::groupxml()");
		
		xml2 = new StringBuffer();
		xml2.append("<groups>\n");
		Enumeration e = population.keys();
		while(e.hasMoreElements()) {
			String tmp = (String)e.nextElement();
			xml2.append("<group id=\"" + tmp + "\" name=\"" + (String)population.get(tmp) + "\" />\n");
		}
		xml2.append("</groups>\n");
		this.xml = xml2.toString();
		xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}
	
	/**
	 * Ajout d'un groupe de publicateurs
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean addgroupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ViewPermissions::addgroupinit()");
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ViewPermissions::addgroupinit()() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butvalid");
		
		// Slection bouton
		if(button == null) {
			log("ViewPermissions::addgroupinit() : redirection canal annuaire");
			mainChannel.redirect(runtimeData, "annuairepub");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String [] gids = runtimeData.getParameterValues("gid");
		
		// Vrification paramtres
		if(gids == null || gids.length == 0) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataWriteManager
		IDataWriteManager data = DataFactory.makeWrite();
		
		for(int i=0;i<gids.length;i++) {
			String gid = gids[i];
			if(!groups.contains(gid)) {
				try {
					data.addPublicators(folderid, gid, true);
				}
				catch(DataException e) {
					log(Priority.ERROR, "ViewPermissions::addgroupinit() : " + e);
				}
			}
		}
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "permissions");
		return Boolean.FALSE;
	}
	
	/**
	 * Ajout d'un publicateur (retour du servant Annuaire)
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean addpubinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ViewPermissions::addpubinit()");
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ViewPermissions::addpubinit()() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration rsultats servant
		Object [] res = mainChannel.getServantResults();
		if(res == null || res.length != 1) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)res[0];
		
		// Rcupration IDataWriteManager
		IDataWriteManager data = DataFactory.makeWrite();
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		if(security == null) {
			log(Priority.ERROR, "ViewPermissions::addpubinit() : security = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d'accder au service de scurit"));
			return Boolean.FALSE;
		}
		
		String id = null;
		String username = null;
		try {
			id = selected.getIdentifiant();
			username = group.getUserDisplayName(id);
			if(!security.isIntranetAccessible(intranet, id)) {
				log(Priority.ERROR, "ViewPermissions::addpubinit() : " + username + " ne fait pas partie de cet intranet");
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean(username + " n'est pas membre de cet intranet"), "permissions", parameters);
				return Boolean.FALSE;
			}
			if(users.contains(id)) {
				runtimeData.setParameter("folderid", folderid);
				mainChannel.redirect(runtimeData, "permissions");
				return Boolean.FALSE;
			}
			data.addPublicator(folderid, id, true);
		}
		catch(GroupException e) {
			log(Priority.ERROR, "ViewPermissions::addpubinit() : " + e);
			log(Priority.ERROR, "ViewPermissions::addpubinit() : " + id + " n'est pas un utilisateur du portail");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(id + " n'est pas un utilisateur connu du portail"), "permissions", parameters);
			return Boolean.FALSE;
		}
		catch(SecurityException e) {
			log(Priority.ERROR, "ViewPermissions::addpubinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		catch(DataException e) {
			log(Priority.ERROR, "ViewPermissions::addpubinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "permissions");
		return Boolean.FALSE;
	}
	
	/**
	 * Ajout d'un valideur (retour du servant Annuaire)
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean addvalinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ViewPermissions::addvalinit()");
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ViewPermissions::addvalinit()() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'tes pas autoris  effectuer cette opration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration rsultats servant
		Object [] res = mainChannel.getServantResults();
		if(res == null || res.length != 1) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)res[0];
		
		// Rcupration IDataWriteManager
		IDataWriteManager data = DataFactory.makeWrite();
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		if(security == null) {
			log(Priority.ERROR, "ViewPermissions::addvalinit() : security = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d'accder au service de scurit"));
			return Boolean.FALSE;
		}
		
		String id = null;
		String username = null;
		try {
			id = selected.getIdentifiant();
			username = group.getUserDisplayName(id);
			if(!security.isIntranetAccessible(intranet, id)) {
				log(Priority.ERROR, "ViewPermissions::addvalinit() : " + username + " ne fait pas partie de cet intranet");
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean(username + " n'est pas membre de cet intranet"), "permissions", parameters);
				return Boolean.FALSE;
			}
			if(validators.contains(id)) {
				runtimeData.setParameter("folderid", folderid);
				mainChannel.redirect(runtimeData, "permissions");
				return Boolean.FALSE;
			}
			data.addValidator(folderid, id, false, true);
		}
		catch(GroupException e) {
			log(Priority.ERROR, "ViewPermissions::addvalinit() : " + e);
			log(Priority.ERROR, "ViewPermissions::addvalinit() : " + id + " n'est pas un utilisateur du portail");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(id + " n'est pas un utilisateur connu du portail"), "permissions", parameters);
			return Boolean.FALSE;
		}
		catch(SecurityException e) {
			log(Priority.ERROR, "ViewPermissions::addvalinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		catch(DataException e) {
			log(Priority.ERROR, "ViewPermissions::addvalinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "permissions");
		return Boolean.FALSE;
	}
}
