package org.esupportail.portal.channels.CIntranet.config;

import java.util.Hashtable;

import org.esupportail.portal.channels.CIntranet.beans.Ressource;

/**
 * IntranetConfig<br>
 * <br>
 * Interface dcrivant quelles doivent tre les mthodes  implmenter par la classe<br>
 * s'occupant de la configuration de l'application spcifiques au canal Intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 */


public interface IntranetConfig {

	/**
	 * La classe d'implmentation du IDataReadManager
	 * @return
	 */
	public String getDataReadManager();
	
	/**
	 * La classe d'implmentation du IDataWriteManager
	 * @return
	 */
	public String getDataWriteManager();

	/**
	 * La classe d'implmentation du IDataReadManager
	 * @param classname
	 */
	public void setDataReadManager(String classname);
	
	/**
	 * La classe d'implmentation du IDataWriteManager
	 * @param classname
	 */
	public void setDataWriteManager(String classname);

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @return
	 */
	public String getSecurityManager();

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @param classname
	 */
	public void setSecurityManager(String classname);

	/**
	 * La classe d'implmentation du IGroupManager
	 * @return
	 */
	public String getGroupManager();

	/**
	 * La classe d'implmentation du IGroupManager
	 * @param classname
	 */
	public void setGroupManager(String classname);

	/**
	 * La liste des ressources physiques de stockage
	 * @return
	 */
	public Hashtable getRessources();

	/**
	 * Ajout d'une ressource physique de stockage
	 * @param res
	 */
	public void addRessource(Ressource res);
	
	/**
	 * La liste des annuaires  utiliser
	 * @return
	 */
	public String getAnnuaires();
	
	/**
	 * La liste des annuaires  utiliser
	 * @param liste
	 */
	public void setAnnuaires(String liste);
}
