package org.esupportail.portal.channels.CIntranet.data;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.jasig.portal.services.LogService;

/**
 * DataFactory<br>
 * <br>
 * Fabrique de IDataManagers (Read ou Write)<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */

public class DataFactory {
	
	private static Priority nivlog = Priority.DEBUG;
	
	/**
	 * Construit un IDataReadManager
	 * @return L'implmentation du IDataReadManager correspondante
	 */
	public static IDataReadManager makeRead() {
		Class dataManagerClass = null;
		   Object dataManagerObject = null;
		   IDataReadManager res = null;
		   String classname = Config.getInstance().getDataReadManager();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::makeRead() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::makeRead() : Tentative d'instanciation du DataReadManager " + classname);
		    dataManagerClass = Class.forName(classname);
		    dataManagerObject = dataManagerClass.newInstance();
		    res = (IDataReadManager)dataManagerObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::makeRead() : Echec de l'instanciation du DatabaseManager " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::makeRead() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataWriteManager
	 * @return L'implmentation du IDataWriteManager correspondante
	 */
	public static IDataWriteManager makeWrite() {
		Class dataManagerClass = null;
		Object dataManagerObject = null;
		IDataWriteManager res = null;
		String classname = Config.getInstance().getDataWriteManager();
		
		if(classname == null) {
			LogService.log(Priority.ERROR, "DataFactory::makeWrite() : classname null");
			return res;
		}
		
		try {
			LogService.log(nivlog, "DataFactory::makeWrite() : Tentative d'instanciation du DataWriteManager " + classname);
			dataManagerClass = Class.forName(classname);
			dataManagerObject = dataManagerClass.newInstance();
			res = (IDataWriteManager)dataManagerObject;
		}
		catch(Exception e) {
			res = null;
			LogService.log(Priority.ERROR, "DataFactory::makeWrite() : Echec de l'instanciation du DataWriteManager " + classname);
			LogService.log(Priority.ERROR, "DataFactory::makeWrite() : Exception " + e);
		}
		return res;
	}
}
