package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.Path;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.channels.CIntranet.beans.SubFolder;

/**
 * IDataReadManager<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * le gestionnaire de donnes pour la lecture<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.3
 */


public interface IDataReadManager {
	
	/************************************************************
	 *	Intranets												* 
	 ************************************************************/
	
	/**
	 * Rcupration d'un intranet
	 * @param id L'identifiant d'intranet
	 * @return L'intranet correspondant
	 * @throws DataException
	 */
	public Intranet getIntranet(String id) throws DataException;

	/**
	 * Rcupration de la liste de tous les intranets
	 * @return La liste de tous les intranets
	 * @throws DataException
	 */
	public Collection getIntranets() throws DataException;
	
	
	/************************************************************
	 *	Populations												* 
	 ************************************************************/
	
	/**
	 * Rcupration d'une population
	 * @param id L'identifiant d'intranet
	 * @return La population de l'intranet
	 * @throws DataException
	 */
	public Population getPopulation(String id) throws DataException;
	
	
	/************************************************************
	 *	Super Utilisateurs										* 
	 ************************************************************/
	
	/**
	 * Rcupration des super-utilisateurs
	 * @return La liste des super-utilisateurs
	 * @throws DataException
	 */
	public Collection getSuperUsers() throws DataException;

	
	/************************************************************
	 *	Dossiers												* 
	 ************************************************************/
	
	/**
	 * Rcupration d'un dossier
	 * @param id L'identifiant du dossier
	 * @param sub Si true alors on rcupre galement les sous-dossiers<br>
	 * et les documents
	 * @return Le dossier
	 * @throws DataException
	 */
	public Folder getFolder(String id, boolean sub) throws DataException;
	
	/**
	 * Rcupration d'un sous-dossier
	 * @param id L'identifiant du sous-dossier
	 * @return Le sous-dossier
	 * @throws DataException
	 */
	public SubFolder getSubFolder(String id) throws DataException;
	
	/**
	 * Rcupration des sous-dossiers
	 * @param id L'identifiant du dossier parent
	 * @return La liste des sous-dossiers
	 * @throws DataException
	 */
	public Collection getSubFolders(String id) throws DataException;
	
	
	/************************************************************
	 *	Documents												* 
	 ************************************************************/
	
	/**
	 * Rcupration d'un document
	 * @param intranet L'identifiant de l'intranet auquel appartient le document
	 * @param id L'identifiant du dossier auquel appartient le document
	 * @return Le document
	 * @throws DataException
	 */
	public Document getDocument(String intranet, String id) throws DataException;
	
	/**
	 * Rcupration des documents d'un dossier
	 * @param id L'identiant du dossier
	 * @return La liste des documents
	 * @throws DataException
	 */
	public Collection getDocuments(String id) throws DataException;
	
	
	/************************************************************
	 *	Recherche												* 
	 ************************************************************/
	
	/**
	 * Recherche de documents par nom / description
	 * @param intranet L'intranet concern
	 * @param name Tout ou partie du nom du document
	 * @param description Tout ou partie de la description du document
	 * @param valid La validit des documents recherchs
	 * @return La liste des documents correspondants au(x) critre(s) de recherche
	 */
	public Collection findByName(String intranet, String name, String description, boolean valid) throws DataException;
	
	/**
	 * Recherche de tous les documents en attente de validation
	 * @param intranet L'intranet concern
	 * @return La liste des documents en attente de validation
	 * @throws DataException
	 */
	public Collection findInvalid(String intranet, String name, String description) throws DataException;
	
	/**
	 * Recherche des documents dposs par un utilisateur en attente de validation
	 * @param intranet L'intranet concern
	 * @param login L'identifiant de l'utilisateur
	 * @return La liste des documents de l'utilisateur en attente de validation
	 * @throws DataException
	 */
	public Collection findMyInvalid(String intranet, String name, String description, String login) throws DataException;
	
	/************************************************************
	 *	Types MIME												* 
	 ************************************************************/

	/**
	 * Rcupration des types MIME valides
	 * @return La liste des types MIME
	 * @throws DataException
	 */
	public Collection getMIMEs() throws DataException;

	
	/************************************************************
	 *	Valideurs												* 
	 ************************************************************/
	
	/**
	 * Rcupration des valideurs d'un dossier
	 * @param id L'identifiant du dossier
	 * @return La liste des valideurs
	 * @throws DataException
	 */
	public Collection getValidators(String id) throws DataException;
	
	
	/************************************************************
	 *	Publicateurs											* 
	 ************************************************************/
	
	/**
	 * Rcupration des publicateurs d'un dossier
	 * @param id L'identifiant du dossier
	 * @return La liste des publicateurs
	 * @throws DataException
	 */
	public Collection getUsersPublicators(String id) throws DataException;
	
	/**
	 * Rcupration des groupes de publicateurs d'un dossier
	 * @param id L'identifiant du dossier
	 * @return La liste des groupes de publicateurs
	 * @throws DataException
	 */
	public Collection getGroupsPublicators(String id) throws DataException;
	
	
	/************************************************************
	 *	Divers													* 
	 ************************************************************/
	
	/**
	 * Rcupration du chemin d'un dossier
	 * @param id L'identifiant du dossier
	 * @return Le chemin du dossier
	 */
	public Path getPath(String id) throws DataException;
}
