package org.esupportail.portal.channels.CIntranet.groups;

import java.util.Collection;
import java.util.Iterator;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.cache.Cache;
import org.esupportail.portal.channels.CIntranet.cache.CircularCache;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.PersonDirectory;

/**
 * PortalGroupManager<br>
 * <br>
 * Implmentation d'un IGroupManager utilisant les groupes de uPortal<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */

public class PortalGroupManager implements IGroupManager {

	private static Priority nivlog = Priority.DEBUG;
	private Cache USER_NAMES = null;
	private Cache GROUP_NAMES = null;
	
	/**
	 * Constructeur
	 */
	public PortalGroupManager() {
		USER_NAMES = new CircularCache(256);
		GROUP_NAMES = new CircularCache(32);
	}
	
	/**
	 * Retourne le nom d'usage correspondant  un identifiant d'utilisateur
	 * @param userid L'identifiant de l'utilisateur
	 * @return Le nom d'usage
	 * @throws GroupException
	 */
	public String getUserDisplayName(String userid) throws GroupException {
		LogService.log(nivlog, "PortalGroupManager::getUserDisplayName()");
		
		String cachedname = (String)USER_NAMES.get(userid);
		if(cachedname != null) {
				return cachedname;
		}
		
		RestrictedPerson user = null;
		Object displayName = null;
		user = PersonDirectory.getRestrictedPerson(userid);
		if(user == null) {
			throw new GroupException("Utilisateur inconnu " + userid);
		}
		
		displayName = user.getAttribute("displayName");
		
		if(displayName == null) {
			throw new GroupException("Utilisateur inconnu " + userid);
		}
		USER_NAMES.put(userid, displayName.toString());
		return displayName.toString();
	}
	
	/**
	 * Retourne le nom d'usage correspondant  un identifiant de groupe
	 * @param groupid L'identifiant du groupe
	 * @return Le nom d'usage
	 * @throws GroupException
	 */
	public String getGroupDisplayName(String groupid) throws GroupException {
		LogService.log(nivlog, "PortalGroupManager::getGroupDisplayName()");
		
		String cachedname = (String)GROUP_NAMES.get(groupid);
		if(cachedname != null) {
			return cachedname;
		}
		
		if(groupid.equals("_EVERYBODY")) {
			GROUP_NAMES.put(groupid, "Tous les membres");
			return "Tous les membres";
		}
		
		Class groupType = org.jasig.portal.groups.IGroupMember.class;
		IEntityGroup myGroup = null;
		try {
			myGroup = GroupService.findGroup(groupid);
			if(myGroup != null) {
				String res = myGroup.getName();
				GROUP_NAMES.put(groupid, res);
				return res;
			}
			else {
				LogService.log(Priority.ERROR, "PortalGroupManager::getGroupDisplayName() : Groupe " + groupid + " inexistant");
				throw new GroupException("Groupe " + groupid + " inexistant");
			}
		}
		catch(GroupsException e) {
			LogService.log(Priority.ERROR, "PortalGroupManager::isMemberOf() : Erreur d'accs aux groupes");
			LogService.log(Priority.ERROR, "PortalGroupManager::isMemberOf() : GroupsException " + e);
			throw new GroupException("Erreur d'accs aux groupes");
		}
	}
	
	/**
	 * Indique si un utilisateur est membre d'un groupe
	 * @param userid L'identifiant de l'utilisateur
	 * @param group L'identifiant du groupe
	 * @return true si l'utilisateur est membre, false sinon
	 * @throws GroupException
	 */
	public boolean isMemberOf(String userid, String group) throws GroupException {
		LogService.log(nivlog, "PortalGroupManager::isMemberOf() : user : " + userid + " group : " + group);
		IEntity user = null;
		try {
			user = GroupService.getEntity(userid, org.jasig.portal.security.IPerson.class);
			if(user != null) {
				Iterator i = user.getAllContainingGroups();
				while(i.hasNext()) {
					IGroupMember tmp = (IGroupMember)i.next();
					if(tmp.getKey().equals(group)) {
						return true;
					}
				}
				return false;
			}
			else {
				LogService.log(Priority.ERROR, "PortalGroupManager::isMemberOf() : Utilisateur " + userid + " inexistant");
				throw new GroupException("Utilisateur " + userid + " inexistant");
			}
		}
		catch(GroupsException e) {
			LogService.log(Priority.ERROR, "PortalGroupManager::isMemberOf() : Erreur d'accs aux groupes");
			LogService.log(Priority.ERROR, "PortalGroupManager::isMemberOf() : " + e);
			throw new GroupException("Erreur d'accs aux groupes");
		}
	}
	
	/**
	 * Indique si un utilisateur est membre d'un des groupes d'une liste
	 * @param userid L'identifiant de l'utilisateur
	 * @param groups La liste des identifiants de groupe
	 * @return true si l'utilisateur est membre d'au moins un des groupes , false sinon
	 * @throws GroupException
	 */
	public boolean isMemberOf(String userid, Collection groups) throws GroupException {
		Iterator i = groups.iterator();
		while(i.hasNext()) {
			String group = (String)i.next();
			LogService.log(nivlog, "PortalGroupManager::isMemberOf() : " + group);
			if(isMemberOf(userid, group)) {
				return true;
			}
		}
		return false;
	}
}
