package org.esupportail.portal.channels.CIntranet.storage;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.jasig.portal.services.LogService;

/**
 * StorageFactory<br>
 * <br>
 * Fabrique de IStorageControler<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class StorageFactory {
	
	private static Hashtable singletons = null;
	private static Priority nivlog = Priority.DEBUG;
	
	/**
	 * Construit un IStorageControler  partir de la ressource<br>
	 * dclare dans le fichier de configuration
	 * @param ressource La ressource  laquelle on souhaite accder
	 * @return L'implmentation du IStorageControler correspondante
	 */
	public static IStorageControler make(String ressource) {
		IStorageControler res = null;
		
		if(singletons == null) {
			singletons = new Hashtable();
		}
		else {
			 res = (IStorageControler)singletons.get(ressource);
			if(res != null) {
				return res;
			}
		}
		
		Class storageControlerClass = null;
		Object storageControlerObject = null;
		Ressource current = (Ressource)Config.getInstance().getRessources().get(ressource);
		if(current == null) {
			LogService.log(Priority.ERROR, "StorageFactory::make() : ressource null");
			return res;
		}
		
		String classname = current.getClassname();
		
		try {
			LogService.log(nivlog, "StorageFactory::make() : Tentative d'instanciation du StorageControler " + ressource + " " + classname);
			storageControlerClass = Class.forName(classname);
			storageControlerObject = storageControlerClass.newInstance();
			res = (IStorageControler)storageControlerObject;
			res.setParameters(current.getParameters());
		}
		catch(Exception e) {
			res = null;
			LogService.log(Priority.ERROR, "StorageFactory::make() : Echec de l'instanciation du StorageControler " + ressource + " " + classname);
			LogService.log(Priority.ERROR, "StorageFactory::make() : Exception " + e);
		}
		singletons.put(ressource, res);
		return res;
	}
}
