package org.esupportail.portal.channels.CIntranet.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.esupportail.portal.channels.CIntranet.config.Config;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.MultipartDataSource;

/**
 * UploadWorker<br>
 * <br>
 * Classe dlgue pour la rcupration de fichiers uploads<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class UploadWorker {

	private ChannelRuntimeData runtimeData = null;
	private MultipartDataSource mps = null;
	private int size = -1;
	
	/**
	 * Constructeur
	 * @param rd Les ChannelRuntimeData contenant le fichier upload
	 */
	public UploadWorker(ChannelRuntimeData rd) {
		runtimeData = rd;
	}
	
	/**
	 * Dclenche la rcupration du fichier
	 * @param parameter Le nom du paramtre contenant le fichier upload
	 * @throws SizeLimitException
	 * @throws FileNotFoundException
	 */
	public void parseFile(String parameter) throws SizeLimitException, FileNotFoundException {
		Object file = runtimeData.getObjectParameter(parameter);
		if(file == null) {
			throw new FileNotFoundException();
		}
		mps = (MultipartDataSource)file;
		
		InputStream stream = null;
		try {
			stream = mps.getInputStream();
		}
		catch(IOException e) {
			throw new FileNotFoundException();
		}
		int filesize = 0;
		try {
			filesize = stream.available();
			stream.close();
		}
		catch(IOException e) {
			throw new FileNotFoundException();
		}
		
		if(getSize() < filesize) {
			throw new SizeLimitException();
		}
	}

	/**
	 * Retourne la taille du fichier upload
	 * @return
	 */
	private int getSize() {
		return Config.getInstance().getSizeUpload();
	}

	
	/**
	 * Retourne le type MIME du fichier upload
	 * @return
	 */	
	public String getContentType() {
		return mps.getContentType();
	}
	
	/**
	 * Retourne le nom du fichier upload
	 * @return
	 */
	public String getName() {
		return mps.getName();
	}
	
	/**
	 * Retourne un flux de lecture sur le fichier upload
	 * @return
	 * @throws IOException
	 */
	public InputStream getInputStream() throws IOException {
		return mps.getInputStream();
	}
}
