package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collection;
import java.util.Iterator;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * ListIntranets<br>
 * <br>
 * Cette action prend en charge le listage des intranets existants<br>
 * et donne accs aux diffrentes fonctionnalits du canal d'administration<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.3
 * 
 */
public class ListIntranets extends AdminAction {

    private Collection intranets = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ListIntranets(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("ListIntranets::action()");
        
        // Rcupration IDataReadManager
		IDataControler data = DataFactory.make();
		
		// Rcupration Intranets
		try {
			intranets = data.getIntranets();
		}
		catch(DataException e) {
			log(Priority.ERROR, "ListIntranets::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
			return Boolean.FALSE;
		}
        return Boolean.TRUE;
    }
    
    /**
     * Affiche la liste des intranets
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        log("ListIntranets::setXML()");
        StringBuffer xml = new StringBuffer();
        xml.append("<intranets>\n");
        Iterator i = intranets.iterator();
        while(i.hasNext()) {
            Intranet tmp = (Intranet)i.next();
            tmp.setRessource(((Ressource)Config.getInstance().getRessources().get(tmp.getRessource())).getDescription());
            xml.append(tmp.toXMLString());
        }
        xml.append("</intranets>\n");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }
}
