package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.groups.GroupException;
import org.esupportail.portal.channels.CIntranet.groups.GroupFactory;
import org.esupportail.portal.channels.CIntranet.groups.IGroupManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.IGroupMember;

/**
 * ManagePopulation<br>
 * <br>
 * Cette action prend en charge toutes les manipulations concernant<br>
 * l'ajout d'utilisateurs ou de groupes  la population d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.4
 * 
 */
public class ManagePopulation extends AdminAction {

    private String intranet = null;
    private Population population = null;
    private Hashtable groups = null;
    private Hashtable users = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ManagePopulation(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("ManagePopulation::action()");
        
        // Rcupration paramtres
        intranet = runtimeData.getParameter("id");
        
        // Tentative d'accs sans paramtre
        if(intranet == null) {
            log(Priority.ERROR, "ManagePopulation::action() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultadmin");		
			return Boolean.FALSE;
        }
        
        // Rcupration IDataReadManager
        IDataControler data = DataFactory.make();
		
		// Rcupration population
		try {
		    population = data.getPopulation(intranet);
		}
		catch(DataException e) {
		    log(Priority.ERROR, "ManagePopulation::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
			return Boolean.FALSE;
		}
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		// Rcupration des noms de groupes et d'utilisateurs
		groups = new Hashtable();
		Iterator i = population.getGroups().iterator();
		while(i.hasNext()) {
		    String tmp = (String)i.next();
		    try {
		        String name = group.getGroupDisplayName(tmp);
		        groups.put(tmp, name);
		    }
		    catch(GroupException e) {
		        log(Priority.ERROR, "ManagePopulation::action() : " + e);
		    }
		}
		
		users = new Hashtable();
		i = population.getUsers().iterator();
		while(i.hasNext()) {
		    String tmp = (String)i.next();
		    try {
		        String name = group.getUserDisplayName(tmp);
		        users.put(tmp, name);
		    }
		    catch(GroupException e) {
		        log(Priority.ERROR, "ManagePopulation::action() : " + e);
		    }
		}
        
        return Boolean.TRUE;
    }
    
    /**
     * Affiche la population de l'intranet
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        log("ManagePopulation::setXML()");
        
        StringBuffer xml = new StringBuffer();
        xml.append("<population>\n");
        xml.append("<groups>\n");
        Enumeration e = groups.keys();
        while(e.hasMoreElements()) {
            String tmp = (String)e.nextElement();
            xml.append("<group id=\"" + tmp + "\" name=\"" + (String)groups.get(tmp) + "\" />\n");
        }
        xml.append("</groups>\n");
        
        xml.append("<users>\n");
        e = users.keys();
        while(e.hasMoreElements()) {
            String tmp = (String)e.nextElement();
            xml.append("<user id=\"" + tmp + "\" name=\"" + (String)users.get(tmp) + "\" />\n");
        }
        xml.append("</users>\n");
        xml.append("</population>");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }

    /**
     * Traite l'ajout d'un utilisateur
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean userinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("ManagePopulation::userinit()");
        
        // Rcupration rsultats servant
		Object [] result = mainChannel.getServantResults();
		if(result == null || result.length != 1) {
		    runtimeData.setParameter("id", intranet);
			mainChannel.redirect(runtimeData, "population");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)result[0];
        
        // Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		String id = selected.getIdentifiant();
		if(!users.containsKey(id)) {
		    Vector newusers = new Vector();
		    newusers.add(id);
		    Population pop = new Population();
		    pop.setIntranet(intranet);
		    pop.setUsers(newusers);
		    pop.setGroups(new Vector());
		    try {
		        data.addPopulation(pop);
		    }
		    catch(DataException e) {
		        log(Priority.ERROR, "ManagePopulation::userinit() : DatabaseException : " + e);
		        Hashtable parameters = new Hashtable();
		        parameters.put("id", intranet);
				Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "population", parameters);
				return Boolean.FALSE;
		    }
		}
		runtimeData.setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }
    
    /**
     * Traite l'ajout d'un groupe
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean groupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("ManagePopulation::groupinit()");
        
        // Rcupration rsultats servant
		Object [] result = mainChannel.getServantResults();
		if(result == null || result.length == 0) {
		    runtimeData.setParameter("id", intranet);
		    mainChannel.redirect(runtimeData, "population");
			return Boolean.FALSE;
		}
        
        // Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		Population pop = new Population();
		pop.setIntranet(intranet);
		Vector newgroups = new Vector();
		
		for(int i=0;i<result.length;i++) {
		    IGroupMember tmp = (IGroupMember)result[i];
		    String id = tmp.getKey();
		    if(!groups.containsKey(id)) {
		        newgroups.add(id);
		    }
		}
		
		if(newgroups.size() > 0) {
		    pop.setGroups(newgroups);
		    pop.setUsers(new Vector());
		    try {
		        data.addPopulation(pop);
		    }
		    catch(DataException e) {
		        log(Priority.ERROR, "ManagePopulation::groupinit() : DatabaseException : " + e);
		        Hashtable parameters = new Hashtable();
		        parameters.put("id", intranet);
				Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "population", parameters);
				return Boolean.FALSE;
		    }
		}
		runtimeData.setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }
}
