package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Mime;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.PortalException;

/**
 * Download<br>
 * <br>
 * Cette action prend en charge le tlchargement d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.4
 * 
 */

public class Download extends IntranetAction implements IMimeResponse {

	private String name = null;
	private String mime = null;
	private InputStream in = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public Download(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.USER
	 */
	public int getLevel() {
		return ISecurityManager.USER;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return  Boolean.FALSE (pas d'affichage) 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("Download::action()");
		
		// Rcupration paramtres
		String id = runtimeData.getParameter("id");
		
		// Tentative d'accs sans paramtre
		if(id == null) {
			log(Priority.ERROR, "Download::action() : Erreur d'acc\u00E8s \u00E0 la page");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration document, ressource et types MIME
		Document doc = null;
		Collection mimes = null;
		try {
			doc = data.getDocument(intranet, id);
			mimes = data.getMIMEs();
		}
		catch(DataException e) {
			log(Priority.ERROR, "Download::action() : "  + e);
			return Boolean.FALSE;
		}
		
		// Rcupration informations fichier / MIME
		name = doc.getFile();
		Iterator i = mimes.iterator();
		while(i.hasNext()) {
			Mime tmp = (Mime)i.next();
			if(tmp.getExtension().equals(doc.getExtension())) {
				mime = tmp.getType();
			}
		}
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		// Rcupration InputStream
		try {
			in = store.loadDocument(intranet, doc);
		}
		catch(StorageException e) {
			log(Priority.ERROR, "Download::action() : " + e);
		}
		return Boolean.FALSE;
	}

	/**
	 * Retourne le type MIME du document
	 * @return Le type MIME
	 */
	public String getContentType() {
		return mime;
	}

	/**
	 * Retourne un InputStream correspondant au fichier  tlcharger
	 * @return Le flux de donnes
	 */
	public InputStream getInputStream() throws IOException {
		return in;
	}

	/**
	 * Mthode non utilise
	 * @param out Un OutputStream vers le navigateur du client
	 */
	public void downloadData(OutputStream out) throws IOException {
	}

	/**
	 * Retourne le nom du fichier
	 * @return Le nom du fichier
	 */
	public String getName() {
		String result = null;
		result = name.replaceAll(" ", "_");
		result = result.replaceAll("[\u00E0\u00E1\u00E2\u00E3\u00E4]", "a");
		result = result.replaceAll("[\u00E7]", "c");
		result = result.replaceAll("[\u00E8\u00E9\u00EA\u00EB]", "e");
		result = result.replaceAll("[\u00EC\u00ED\u00EE\u00EF]", "i");
		result = result.replaceAll("[\u00F1]", "n");
		result = result.replaceAll("[\u00F2\u00F3\u00F4\u00F5\u00F6]", "o");
		result = result.replaceAll("[\u00F9\u00FA\u00FB\u00FC]", "u");
		
		result = result.replaceAll("[\u00C0\u00C1\u00C2\u00C3\u00C4]", "A");
		result = result.replaceAll("[\u00C7]", "C");
		result = result.replaceAll("[\u00C8\u00C9\u00CA\u00CB]", "E");
		result = result.replaceAll("[\u00CC\u00CD\u00CE\u00CF]", "I");
		result = result.replaceAll("[\u00D1]", "N");
		result = result.replaceAll("[\u00D2\u00D3\u00D4\u00D5\u00D6]", "O");
		result = result.replaceAll("[\u00D9\u00DA\u00DB\u00DC]", "U");
		
		return result;
	}

	/**
	 * Retourne la liste des headers HTTP  envoyer au navigateur
	 * @return La liste des headers
	 */
	public Map getHeaders() {
		HashMap map = new HashMap();
		map.put("Content-disposition", "attachment; filename=" + getName());
		return map;
	}

	/**
	 * Mthode appele si une erreur se produit durant le tlchargement
	 * @param e L'exception leve
	 */
	public void reportDownloadError(Exception e) {
		log(Priority.FATAL, "Download::reportingDownloadError() : " + e);
	}
}
