package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.esupportail.portal.channels.CIntranet.beans.Document;

/**
 * Filters<br>
 * <br>
 * Cette classe dfinit des filtres pour les documents  afficher<br>
 * lors d'une recherche ou d'un affichage classique<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.0
 * 
 */
public class Filters {
    
    /**
     * Filtre les documents  afficher pour un valideur
     * @param in La liste complte des documents
     * @return La liste des documents filtrs
     */
    public static Collection filterValidator(Collection in) {
        Vector res = new Vector();
        Iterator i = in.iterator();
        while(i.hasNext()) {
            Document tmp = (Document)i.next();
            
            // On filtre les documents modifis
            if(tmp.isValid()) {
                res.add(tmp);
            }
            else if(tmp.isNew()) {
                res.add(tmp);
            }
        }
        return res;
    }
    
    /**
     * Filtre les documents  afficher pour un publicateur
     * @param in La liste complte des documents
     * @return La liste des documents filtrs
     */
    public static Collection filterPublicator(Collection in, String login) {
        Vector res = new Vector();
        Iterator i = in.iterator();
        while(i.hasNext()) {
            Document tmp = (Document)i.next();
            
            // On filtre les documents modifis et les documents invalides dposs
            // par une autre personne
            if(tmp.isValid()) {
                res.add(tmp);
            }
            else if(tmp.isNew() && tmp.getAuthor().equals(login)) {
                res.add(tmp);
            }
        }
        return res;
    }
    
    /**
     * Filtre les documents  afficher pour un utilisateur
     * @param in La liste complte des documents
     * @return La liste des documents filtrs
     */
    public static Collection filterUser(Collection in) {
        Vector res = new Vector();
        Iterator i = in.iterator();
        while(i.hasNext()) {
            Document tmp = (Document)i.next();
            
            // On filtre les documents invalides
            if(tmp.isValid()) {
                res.add(tmp);
            }
        }
        return res;
    }
}
