package org.esupportail.portal.channels.CIntranet.actions.intranet;

import org.apache.log4j.Priority;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * FindDocuments<br>
 * <br>
 * Cette action prend en charge la recherche de documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */
public class FindDocuments extends SubChannel {

    private String intranet = null;
    private String login = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public FindDocuments(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Mthode appele si la personne a le niveau requis
	 * @return  Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
    public Boolean init() throws PortalException, FrameWorkException {
        log("FindDocuments::init()");
        
        login = mainChannel.getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
		intranet = (String)mainChannel.getStaticData().get("intranet");
		
		// Vrification paramtres
		if(intranet == null || login == null) {
			log(Priority.ERROR, "FindDocuments::init() : intranet = null || login = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "default");
			return Boolean.FALSE;
		}
        
        return Boolean.TRUE;
    }
    
    /**
	 * Affiche le formulaire de recherche
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
	    log("FindDocuments::setXML()");
	    
	    return Boolean.TRUE;
	}
	
	/**
	 * Traitement du formulaire
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean findinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
	    log("FindDocuments::findinit()");
	    
	    return Boolean.FALSE;
	}
	
	/**
	 * Recherche standard
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean nameinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
	    log("FindDocuments::nameinit()");
	    
	    return Boolean.TRUE;
	}
	
	/**
	 * Affiche le rsultat de la recherche
	 * @return Boolean.TRUE
	 */
	public Boolean namexml() throws FrameWorkException {
	    log("FindDocuments::namexml()");
	    
	    return Boolean.TRUE;
	}
	
	/**
	 * Recherche de documents en attente de validation
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean invalidinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
	    log("FindDocuments::invalidinit()");
	    
	    return Boolean.TRUE;
	}
	
	/**
	 * Affiche le rsultat de la recherche
	 * @return Boolean.TRUE
	 */
	public Boolean invalidxml() throws FrameWorkException {
	    log("FindDocuments::invalidxml()");
	    
	    return Boolean.TRUE;
	}
	
	/**
	 * Recherche de documents personnels en attente de validation
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean myinvalidinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
	    log("FindDocuments::myinvalidinit()");
	    
	    return Boolean.TRUE;
	}
	
	/**
	 * Affiche le rsultat de la recherche
	 * @return Boolean.TRUE
	 */
	public Boolean myinvalidxml() throws FrameWorkException {
	    log("FindDocuments::myinvalidxml()");
	    
	    return Boolean.TRUE;
	}
}
