package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.security.SecurityFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * IntranetAction<br>
 * <br>
 * Cette action prend en charge le listage des intranets accessibles<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.3
 * 
 */

public class ListIntranets extends SubChannel {

	private Collection intranets = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ListIntranets(MainChannel mainChannel) {
		super(mainChannel);
		log("ListIntranets::ListIntranets()");
	}
	
	/**
	 * Recherche des intranets accessibles
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		log("ListIntranets::init()");
		runtimeData = rd;
		
		// Rcupration paramtres statiques
		String login = mainChannel.getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
		mainChannel.getStaticData().remove("intranet");
		
		// Rcupration paramtres runtime
		String allintranets = runtimeData.getParameter("all");
		
		// Prparation variables
		boolean superuser = false;
		boolean all = false;
		Collection intranets = null;
		if(allintranets != null && allintranets.equals("true")) {
			all = true;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		try {
			log("ListIntranets::init() : data.getIntranets()");
			intranets = data.getIntranets();
		}
		catch(DataException e) {
			log(Priority.ERROR, "ListIntranets::init() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()));
			return Boolean.FALSE;
		}
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		if(security == null) {
			log(Priority.ERROR, "ListIntranets::init() : security = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d'acc\u00E9der au service de s\u00E9curit\u00E9"));
			return Boolean.FALSE;
		}
				
		try {
			log("ListIntranets::init() : security.isSuperUser()");
			superuser = security.isSuperUser(login);
			
			// Filtrage des intranets
			if(superuser && all) {
				this.intranets = intranets;
				xslParameters.put("superuser", "true");
				xslParameters.put("all", "true");
			}
			else {
				this.intranets = new Vector();
				Iterator i = intranets.iterator();
				while(i.hasNext()) {
					Intranet tmp = (Intranet)i.next();
					if(security.isIntranetAccessible(tmp.getId(), login)) {
						log("ListIntranets::init() : " + tmp.getName() + " accessible");
						this.intranets.add(tmp);
					}
				}
				
				if(superuser) {
					xslParameters.put("superuser", "true");
					xslParameters.put("all", "false");
				}
				else {
					xslParameters.put("superuser", "false");
					xslParameters.put("all", "false");
				}
			}
		}
		catch(SecurityException e) {
			log(Priority.ERROR, "ListIntranets::init() : SecurityException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()));
			return Boolean.FALSE;
		}
		
		if(!superuser && this.intranets.size() == 1) {
			Intranet tmp = (Intranet)this.intranets.iterator().next();
			runtimeData.setParameter("intranet", tmp.getId());
			runtimeData.setParameter("folderid", tmp.getRoot());
			runtimeData.setParameter("ressource", tmp.getRessource());
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche la liste des intranets accessibles
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		log("ListIntranets::setXML()");
		StringBuffer xml = new StringBuffer();
		Iterator i = intranets.iterator();
		while(i.hasNext()) {
			Intranet tmp = (Intranet)i.next();
			xml.append(tmp.toXMLString());
		}
		this.xml = xml.toString();
		log("ListIntranets::setXML() : " + this.xml);
		return Boolean.TRUE;
	}
}
