package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.esupportail.portal.channels.CIntranet.utils.SizeLimitException;
import org.esupportail.portal.channels.CIntranet.utils.UploadWorker;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ModifyDocument<br>
 * <br>
 * Cette action prend en charge la modification d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.3
 * 
 */

public class ModifyDocument extends IntranetAction {

	private Folder dossier = null;
	private Document doc = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ModifyDocument(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.PUBLICATOR
	 */
	public int getLevel() {
		return ISecurityManager.PUBLICATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("ModifyDocument::action");
		
		// Rcupration paramtres
		String id = runtimeData.getParameter("id");
		
		// Tentative d'accs sans paramtres
		if(id == null) {
			log(Priority.ERROR, "ModifyDocument::action() : Erreur d'acc\u00E8s \u00E0 la page");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		if(!id.startsWith("v")) {
			log(Priority.ERROR, "ModifyDocument::action() : Document non valide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de modifier un document qui n'a pas encore \u00E9t\u00E9 valid\u00E9"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataControler data = DataFactory.make();
		
		// Rcupration du dossier et du document
		try {
			dossier = data.getFolder(folderid, false);
			doc = data.getDocument(intranet, id);
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Vrification document
		if(doc.isLocked()) {
			log(Priority.ERROR, "ModifyDocument::action() : Document verrouil\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de modifier un document verrouill\u00E9"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche le formulaire de modification fichier / lien
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
		log("ModifyDocument::setXML()");
		this.xml = doc.toXMLString();
		return Boolean.TRUE;
	}
	
	/**
	 * Positionnement du titre ssl
	 */
	public void setOutput() throws FrameWorkException {
		Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		if(doc.getType() == Document.FILE) {
			setXSL("file");
		}
		else {
			setXSL("link");
		}
	}
	
	/**
	 * Modification des informations d'un fichier
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean fileinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ModifyDocument::fileinit()");
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ModifyDocument::fileinit() : Acc\u00E8s non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butvalid");

		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String name = runtimeData.getParameter("name");
		String description = runtimeData.getParameter("description");
		
		// Tentative d'accs sans paramtres
		if(name == null || description == null) {
			log(Priority.ERROR, "ModifyDocument::fileinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Vrification validit paramtres
		if(name.equals("")) {
			log("ModifyDocument::fileinit() : Nom de fichier vide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("La nom est vide"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		if(description.equals("")) {
			log("ModifyDocument::fileinit() : Description de fichier vide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("La description est vide"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		// Mise  jour du document
		boolean modif = false;
		if(!doc.getName().equals(name)) {
			doc.setFile(name + doc.getExtension());
			modif = true;
		}
		if(!doc.getDescription().equals(description)) {
			doc.setDescription(description);
			modif = true;
		}
		if(modif) {
			doc.setAuthor(login);
			doc.setModificationDate(Date.getCurrentDate());
		}
		else {
			// Aucune modification
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			doc.setId("i" + doc.getId().substring(1));
		}
		else {
			doc.setId("v" + doc.getId().substring(1));
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
			
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
			
		// Modification du fichier
		try {
			data.updateDocument(doc);
			if(!doc.isValid()) {
				store.updateDocument(intranet, doc, null);
			}
			data.commit();
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyDocument::fileinit() : DatabaseException : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		catch(StorageException e) {
			log(Priority.ERROR, "ModifyDocument::fileinit() : StorageException : " + e);
			log(Priority.FATAL, "ModifyDocument::fileinit() : Possible incoh\u00E9rence du syst\u00E8me de fichiers !");
			data.rollback();
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		if(!doc.isValid()) {
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Les modifications seront visibles une fois valid\u00E9es", Message.INFO), "viewfolder", parameters);
			return Boolean.FALSE;
		}
			
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;		
	}
	
	/**
	 * Modification d'un lien
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean linkinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ModifyDocument::linkinit()");
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ModifyDocument::linkinit() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butvalid");

		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String name = runtimeData.getParameter("name");
		String description = runtimeData.getParameter("description");
		String link = runtimeData.getParameter("link");
		
		// Tentative d'accs sans paramtres
		if(name == null || description == null || link == null) {
			log(Priority.ERROR, "ModifyDocument::linkinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Vrification validit paramtres
		if(name.equals("")) {
			log("ModifyDocument::linkinit() : Nom de fichier vide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("La nom est vide"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		if(description.equals("")) {
			log("ModifyDocument::linkinit() : Description de fichier vide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("La description est vide"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		if(link.equals("")) {
			log("ModifyDocument::linkinit() : L'adresse est vide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("L'adresse est vide"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		if(!link.startsWith("http://")) {
			log("ModifyDocument::linkinit() : Mauvais format d'adresse");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("Mauvaise adresse, une adresse valide est du type http://www.exemple.com"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		// Mise  jour du document
		boolean modif = false;
		if(!doc.getName().equals(name)) {
			doc.setName(name);
			modif = true;
		}
		if(!doc.getDescription().equals(description)) {
			doc.setDescription(description);
			modif = true;
		}
		if(!doc.getFile().equals(link)) {
			doc.setFile(link);
			modif = true;
		}
		if(modif) {
			doc.setAuthor(login);
			doc.setModificationDate(Date.getCurrentDate());
		}
		else {
			// Aucune modification
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			doc.setId("i" + doc.getId().substring(1));
		}
		else {
			doc.setId("v" + doc.getId().substring(1));
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Modification du document
		try {
			data.updateDocument(doc);
			data.commit();
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyDocument::linkinit() : DatabaseException : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		if(!doc.isValid()) {
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Les modifications seront visibles une fois valid\u00E9es", Message.INFO), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}

	/**
	 * Modification du contenu d'un fichier
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean contentinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("ModifyDocument::contentinit()");
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : Accs non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butvalid");

		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		UploadWorker worker = new UploadWorker(runtimeData);
		try {
			worker.parseFile("file");
		}
		catch(SizeLimitException e) {
			log("ModifyDocument::contentinit() : Taille de fichier trop importante");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est trop gros"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		catch(FileNotFoundException e) {
			log("ModifyDocument::contentinit() : Aucun fichier attach\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est manquant"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		// Mise  jour du document
		doc.setFile(worker.getName());
		doc.setAuthor(login);
		doc.setModificationDate(Date.getCurrentDate());
		if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			doc.setId("i" + doc.getId().substring(1));
		}
		else {
			doc.setId("v" + doc.getId().substring(1));
		}
		
		String extension = doc.getExtension();
		if(extension == null) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : Type de fichier non valide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("Type de fichier non valide : " + extension), "modifydoc");		
			return Boolean.FALSE;
		}
		
		// Rcupration inputstream
		InputStream filestream = null;
		try {
			filestream = worker.getInputStream();
		}
		catch(IOException e) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de r\u00E9cup\u00E9rer le fichier joint"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Vrification type MIME
		boolean valid = false;
		try {
			valid = data.isValidMIME(extension);
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()));
			return Boolean.FALSE;
		}
		
		if(!valid) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : Mauvais type MIME " + extension);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("Ce type de fichier (" + extension + ") n'est pas valide"), "modifydoc", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		// Modification du document
		try {
			data.updateDocument(doc);
			store.updateDocument(intranet, doc, filestream);
			data.commit();
		}
		catch(DataException e) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : DatabaseException : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		catch(StorageException e) {
			log(Priority.ERROR, "ModifyDocument::contentinit() : StorageException : " + e);
			log(Priority.FATAL, "ModifyDocument::contentinit() : Possible incoh\u00E9rence de la base de donn\u00E9es !");
			data.rollback();
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		if(!doc.isValid()) {
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Les modifications seront visibles une fois valid\u00E9es", Message.INFO), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
