package org.esupportail.portal.channels.CIntranet.actions.intranet;

import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Multiple<br>
 * <br>
 * Cette action prend en charge la traitements multiples sur les documents<br>
 * Elle redirige vers les actions de suppression multiple ou de validation multiple<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public class Multiple extends SubChannel {

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public Multiple(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Dtermine l'action  effectuer et redirige
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		log("Multiple::init()");
		
		// Rcupration paramtres
		String button = runtimeData.getParameter("butvalid");
		
				
		// Suppression multiple
		if(button == null) {
			log("Multiple::init() : Suppression multiple");
			mainChannel.redirect(runtimeData, "deletedocs");
			return Boolean.FALSE;
		}
		
		// Validation multiple
		log("Multiple::init() : Validation multiple");
		mainChannel.redirect(runtimeData, "confval");
		return Boolean.FALSE;
	}
}
