package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * OrderDocument<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.0
 * 
 */
public class OrderDocument extends IntranetAction {

    /**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
    public OrderDocument(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.PUBLICATOR
	 */
    public int getLevel() {
        return ISecurityManager.VALIDATOR;
    }
    
    /**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.FALSE (pas d'affichage) 
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("OrderDocument::action()");
        
        // Rcupration paramtres
		String id = runtimeData.getParameter("id");
		String order = runtimeData.getParameter("order");
		String direction = runtimeData.getParameter("dir");
		
		// Tentative d'accs sans paramtres
		if(id == null || order == null || direction == null) {
			log(Priority.ERROR, "OrderDocument::action() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
        
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Changement d'ordre
		try {
			if(direction.equals("up")) {
			    data.swap(folderid, id, order, new Integer(Integer.parseInt(order) - 1).toString());
			}
			else {
			    data.swap(folderid, id, order, new Integer(Integer.parseInt(order) + 1).toString());
			}
		}
		catch(DataException e) {
			log(Priority.ERROR, "OrderDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Redirection
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
    }
}
