package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.groups.GroupException;
import org.esupportail.portal.channels.CIntranet.groups.GroupFactory;
import org.esupportail.portal.channels.CIntranet.groups.IGroupManager;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * ViewDocument<br>
 * <br>
 * Cette action prend en charge la visualisation d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */

public class ViewDocument extends IntranetAction {

	private Document doc = null;
	private Document doc2 = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ViewDocument(MainChannel mainChannel) {
		super(mainChannel);
	}

	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.USER
	 */
	public int getLevel() {
		return ISecurityManager.USER;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		log("ViewDocument::action()");
		
		// Rcupration des paramtres
		String id = runtimeData.getParameter("id");
		
		// Vrification paramtres
		if(id == null) {
			log(Priority.ERROR, "ViewDocument::action() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration document
		try {
			doc = data.getDocument(intranet, id);
			if((superuser || role == ISecurityManager.VALIDATOR) && doc.isLocked()) {
			    doc2 = data.getDocument(intranet, "i" + id.substring(1));
			}
		}
		catch(DataException e) {
			log(Priority.ERROR, "ViewDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Vrification d'accs
		if(!superuser && role == ISecurityManager.USER && !doc.isValid()) {
			log(Priority.ERROR, "ViewDocument::action() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IGroupManager
		IGroupManager group = GroupFactory.make();
		
		// Rcupration nom de l'auteur
		try {
			doc.setAuthor(group.getUserDisplayName(doc.getAuthor()));
			if((superuser || role == ISecurityManager.VALIDATOR) && doc.isLocked()) {
			    doc2.setAuthor(group.getUserDisplayName(doc2.getAuthor()));
			}
		}
		catch(GroupException e) {
			log(Priority.ERROR, "ViewDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affichage du document
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() throws FrameWorkException {
		log("ViewDocument::setXML()");
		this.xml = doc.toXMLString();
		if((superuser || role == ISecurityManager.VALIDATOR) && doc.isLocked()) {
		    this.xml = doc.toXMLString() + doc2.toXMLString();
		}
		else {
		    this.xml = doc.toXMLString();
		}
		if(superuser) {
			xslParameters.put("role", "validator");
		}
		else {
			switch(role) {
				case ISecurityManager.VALIDATOR: xslParameters.put("role", "validator");break;
				case ISecurityManager.PUBLICATOR: xslParameters.put("role", "publicator");break;
				default : xslParameters.put("role", "user");break;
			}
		}
		addDownloadXslParameter();
		xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}

	/**
	 * Positionnement du titre ssl
	 */
	public void setOutput() throws FrameWorkException {
		Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		if(!superuser && role != ISecurityManager.VALIDATOR) {
		    setXSL("valid");
		}
		else if(doc.isLocked()) {
			setXSL("modified");
		}
		else if(!doc.isValid()) {
			setXSL("invalid");
		}
		else {
		    setXSL("valid");
		}
	}
}
