package org.esupportail.portal.channels.CIntranet.data;

import java.sql.SQLException;

import org.apache.log4j.Priority;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.services.LogService;

/**
 * DataOrder<br>
 * <br>
 * Cette classe dfinit des mthodes pour la gestion de l'ordre d'affichage des documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataOrder implements IDataOrder {
    
    private static Priority nivlog = Priority.DEBUG;
    
    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public void push(Query query, String id) throws DataException {
        LogService.log(nivlog, "DataOrder::push()");
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC + 1 WHERE ID_DOS = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            LogService.log(Priority.ERROR, "DataOrder::push() : " + e);
			LogService.log(Priority.ERROR, "DataOrder::push() : SQL : " + sql);
			throw new DataException("Erreur lors du d\u00E9calage des rangs");
        }
    }
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public void pull(Query query, String id, String order) throws DataException {
        LogService.log(nivlog, "DataOrder::pull()");
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC - 1 WHERE ID_DOS = " + id + " AND ORDER_DOC > " + order;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            LogService.log(Priority.ERROR, "DataOrder::pull() : " + e);
			LogService.log(Priority.ERROR, "DataOrder::pull() : SQL : " + sql);
			throw new DataException("Erreur lors du d\u00E9calage des rangs");
        }
    }
    
    /**
     * Echange le rang de deux documents
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param doc L'identifiant du document
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public void swap(Query query, String id, String doc, String oldorder, String neworder) throws DataException {
        LogService.log(nivlog, "DataOrder::swap()");
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + oldorder + " WHERE ORDER_DOC = " + neworder + " AND ID_DOS = " + id;
        try {
            query.setSql(sql);
            query.update();
            sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + neworder + " WHERE ID_DOC = '" + doc + "' AND ID_DOS = " + id;
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            LogService.log(Priority.ERROR, "DataOrder::swap() : " + e);
			LogService.log(Priority.ERROR, "DataOrder::swap() : SQL : " + sql);
			throw new DataException("Erreur lors de l'inversion des rangs");
        }
        
    }
}
