package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.services.LogService;

/**
 * DataSU<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataSU implements IDataSU {
    
    private static Priority nivlog = Priority.DEBUG;

    /**
	 * Rcupration des super-utilisateurs
	 * @param query La connexion  utiliser
	 * @return La liste des super-utilisateurs
	 * @throws DataException
	 */
    public Collection getSuperUsers(Query query) throws DataException {
        LogService.log(nivlog, "DataSU::getSuperUsers()");
		Collection res = new Vector();
		
		String sql = "SELECT LOGIN FROM INT_SUPERUSER";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				res.add(result.getString("LOGIN"));
			}
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataSU::getSuperUsers() : " + e);
			LogService.log(Priority.ERROR, "DataSU::getSuperUsers() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des super utilisateurs");
		}
		return res;
    }

    /**
	 * Ajout d'un super-utilisateur
	 * @param query La connexion  utiliser
	 * @param login L'identifiant de l'utilisateur
	 */
    public void addSuperUser(Query query, String login) throws DataException {
        LogService.log(nivlog, "DataSU::addSuperUser()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_SUPERUSER(LOGIN) VALUES(");
		sql.append("'" + login + "')");
		
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataSU::addSuperUser() : " + e);
			LogService.log(Priority.ERROR, "DataSU::addSuperUser() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout du super utilisateur");
		}
    }

    /**
	 * Suppression d'un super-utilisateur
	 * @param query La connexion  utiliser
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
    public void removeSuperUser(Query query, String login) throws DataException {
        LogService.log(nivlog, "addSuperUser::removeSuperUser()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_SUPERUSER WHERE ");
		sql.append("LOGIN = '" + login + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "addSuperUser::removeSuperUser() : " + e);
			LogService.log(Priority.ERROR, "addSuperUser::removeSuperUser() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du super utilisateur");
		}
    }
}
