package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.services.LogService;

/**
 * DataValidator<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataValidator implements IDataValidator {
    
    private static Priority nivlog = Priority.DEBUG;

    /**
	 * Rcupration des valideurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return La liste des valideurs
	 * @throws DataException
	 */
    public Collection getValidators(Query query, String id) throws DataException {
        LogService.log(nivlog, "DataValidator::getValidators()");
		Collection res = new Vector();
		
		String sql = "SELECT LOGIN FROM INT_VALIDEUR WHERE ID_DOS = '" + id + "'";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				res.add(result.getString("LOGIN"));
			}
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataValidator::getValidators() : " + e);
			LogService.log(Priority.ERROR, "DataValidator::getValidators() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des valideurs");
		}
		return res;
    }

    /**
	 * Ajout d'un valideur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 */
    public void addValidator(Query query, String id, String login) throws DataException {
        LogService.log(nivlog, "DataValidator::addValidator()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_VALIDEUR(ID_DOS, LOGIN) VALUES(");
		sql.append("'" + id + "', ");
		sql.append("'" + login + "')");
		
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataValidator::addValidator() : " + e);
			LogService.log(Priority.ERROR, "DataValidator::addValidator() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout du valideur");
		}
    }
    
    /**
	 * Ajout d'une liste de valideurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param logins La liste des logins
	 */
	public void addValidator(Query query, String id, Collection logins) throws DataException {
	    LogService.log(nivlog, "DataValidator::addValidator()");
		
		Iterator i = logins.iterator();
	    while(i.hasNext()) {
	        String login = (String)i.next();
	        addValidator(query, id, login);
	    }
	}

    /**
	 * Suppression d'un valideur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
    public void removeValidator(Query query, String id, String login) throws DataException {
        LogService.log(nivlog, "DataValidator::removeValidator()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_VALIDEUR WHERE ");
		sql.append("ID_DOS = '" + id + "' AND ");
		sql.append("LOGIN = '" + login + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataValidator::removeValidator() : " + e);
			LogService.log(Priority.ERROR, "DataValidator::removeValidator() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du valideur");
		}
    }

    /**
	 * Suppression de tous les valideurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
    public void removeAllValidators(Query query, String id) throws DataException {
        LogService.log(nivlog, "DataValidator::removeAllValidators()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_VALIDEUR WHERE ");
		sql.append("ID_DOS = '" + id + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataValidator::removeAllValidators() : " + e);
			LogService.log(Priority.ERROR, "DataValidator::removeAllValidators() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression des valideurs");
		}
    }

}
