package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.utils.database.Query;

/**
 * IDataDocument<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataDocument {

    /**
	 * Rcupration d'un document
	 * @param query La connexion  utiliser
	 * @param intranet L'identifiant de l'intranet auquel appartient le document
	 * @param id L'identifiant du dossier auquel appartient le document
	 * @return Le document
	 * @throws DataException
	 */
	public Document getDocument(Query query, String intranet, String id) throws DataException;
	
	/**
	 * Rcupration des documents d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identiant du dossier
	 * @return La liste des documents
	 * @throws DataException
	 */
	public Collection getDocuments(Query query, String id) throws DataException;
	
	/**
	 * Cration d'un document
	 * @param query La connexion  utiliser
	 * @param doc Le document  crer
	 */
	public void createDocument(Query query, Document doc) throws DataException;
	
	/**
	 * Suppression d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant  supprimer
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
	public void removeDocument(Query query, String id, String intranet) throws DataException;
	
	/**
	 * Mise  jour d'un document
	 * @param query La connexion  utiliser
	 * @param doc Le document  mettre  jour
	 * @throws DataException
	 */
	public void updateDocument(Query query, Document doc) throws DataException;
	
	/**
	 * Validation d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
	public void validDocument(Query query, String id, String intranet) throws DataException;
	
	/**
	 * Identifiant du prochain document
	 * @param query La connexion  utiliser
	 * @return int L'identifiant
	 * @throws DataException
	 */
	public int getNextDocument(Query query, String intranet) throws DataException;
	
	/**
	 * Vrification existence d'un document
	 * @param query La connexion  utiliser
	 * @param doc Le document  vrifier
	 * @return boolean True si le document existe, false sinon
	 */
	public boolean documentExist(Query query, Document doc) throws DataException;
	
	/**
	 * Vrification verrouillage d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  vrifier
	 * @param intranet L'identifiant de l'intranet
	 * @return boolean True si le document est verrouill, faux sinon
	 * @throws DataException
	 */
	public boolean documentIsLocked(Query query, String id, String intranet) throws DataException;

	/**
	 * Verrouille le document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  verrouiller
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
	public void lockDocument(Query query, String id, String intranet) throws DataException;
	
	/**
	 * Dverrouille le document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  dverrouiller
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
	public void unlockDocument(Query query, String id, String intranet) throws DataException;
}
