package org.esupportail.portal.channels.CIntranet.groups;

import java.util.Collection;

/**
 * IGroupManager<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * le gestionnaire de groupes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public interface IGroupManager {
	
	/**
	 * Retourne le nom d'usage correspondant  un identifiant d'utilisateur
	 * @param userid L'identifiant de l'utilisateur
	 * @return Le nom d'usage
	 * @throws GroupException
	 */
	public String getUserDisplayName(String userid) throws GroupException;
	
	/**
	 * Retourne le nom d'usage correspondant  un identifiant de groupe
	 * @param groupid L'identifiant du groupe
	 * @return Le nom d'usage
	 * @throws GroupException
	 */
	public String getGroupDisplayName(String groupid) throws GroupException;
	
	/**
	 * Indique si un utilisateur est membre d'un groupe
	 * @param userid L'identifiant de l'utilisateur
	 * @param group L'identifiant du groupe
	 * @return true si l'utilisateur est membre, false sinon
	 * @throws GroupException
	 */
	public boolean isMemberOf(String userid, String group) throws GroupException;
	
	/**
	 * Indique si un utilisateur est membre d'un des groupes d'une liste
	 * @param userid L'identifiant de l'utilisateur
	 * @param groups La liste des identifiants de groupe
	 * @return true si l'utilisateur est membre d'au moins un des groupes , false sinon
	 * @throws GroupException
	 */
	public boolean isMemberOf(String userid, Collection groups) throws GroupException;
}
