package org.esupportail.portal.channels.CIntranet;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerServantFactory;
import org.jasig.portal.services.GroupService;
import org.xml.sax.ContentHandler;

/**
 * GroupsManagerAdapter<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.0
 * 
 */
public class GroupsManagerAdapter implements IServant {
    
    private IServant slave = null;
    private ChannelStaticData staticData = null;
    
    /**
     * Constructeur
     */
    public GroupsManagerAdapter() {
    }

    public boolean isFinished() {
        if(slave.isFinished()) {
            staticData.setParameter("groupManagerFinished", "false");
            return true;
        }
        return false;
    }

    public Object[] getResults() {
        return slave.getResults();
    }

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        staticData = sd;
        slave = CGroupsManagerServantFactory.getGroupsServantforSelection(staticData, "S\u00E9lectionnez un ou plusieurs groupes", GroupService.EVERYONE, true, true);
        //slave.setStaticData(staticData);
    }

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        slave.setRuntimeData(rd);
    }

    public void receiveEvent(PortalEvent ev) {
        slave.receiveEvent(ev);
    }

    public ChannelRuntimeProperties getRuntimeProperties() {
        return slave.getRuntimeProperties();
    }

    public void renderXML(ContentHandler out) throws PortalException {
        slave.renderXML(out);
    }
}
