package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collection;
import java.util.Iterator;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Mime;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ListMimes<br>
 * <br>
 * Cette action prend en charge l'affichage de la liste des extensions acceptes<br>
 * par le canal intranet et l'ajout d'un nouvelle extension avec son type MIME associ<br>
 * 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */
public class ListMimes extends AdminAction {

    private Collection mimes = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ListMimes(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("ListMimes::action()");
        
        // Rcupration IDataReadManager
        IDataControler data = DataFactory.make();
        
        // Rcupration types MIME
        try {
            mimes = data.getMIMEs();
        }
        catch(DataException e) {
            log(Priority.ERROR, "ListMimes::action() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    
    /**
     * Affiche la liste des types MIME
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        log("ListMimes::setXML()");
        StringBuffer xml = new StringBuffer();
        xml.append("<mimes>\n");
        Iterator i = mimes.iterator();
        while(i.hasNext()) {
            Mime tmp = (Mime)i.next();
            xml.append("<mime extension=\"" + tmp.getExtension() + "\" type=\"" + tmp.getType() + "\" />\n");
        }
        xml.append("</mimes>");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }

    /**
     * Suppression d'un type MIME
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("ListMimes::delinit()");
        
        // Rcupration paramtres
        String extension = runtimeData.getParameter("ext");
        
        // Tentative d'accs sans paramtre
        if(extension == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataControler
        IDataControler data = DataFactory.make();
        
        // Suppression du type MIME
        try {
            data.removeMIME(extension);
        }
        catch(DataException e) {
            log(Priority.ERROR, "ListMimes::delinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "mimes");        
        return Boolean.FALSE;
    }
    
    /**
     * Ajout d'un type MIME
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean addinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("ListMimes::addinit()");
        
        // Rcupration paramtres
        String extension = runtimeData.getParameter("extension");
        String type = runtimeData.getParameter("type");
        
        // Tentative d'accs sans paramtre
        if(extension == null || type == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Vrification paramtres
        if(!extension.matches("^\\.[\\w]+$")) {
            Message.message(mainChannel, runtimeData, new MessageBean("Extension non valide, '.zip' est une bonne extension"), "mimes");
            return Boolean.FALSE;
        }
        
        Mime mime = new Mime();
        mime.setExtension(extension);
        mime.setType(type);
        
        // Rcupration IDataControler
        IDataControler data = DataFactory.make();
        
        // Ajout du type MIME
        try {
            data.createMIME(mime);
        }
        catch(DataException e) {
            log(Priority.ERROR, "ListMimes::addinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "mimes");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "mimes");        
        return Boolean.FALSE;
    }
}
