package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collection;
import java.util.Iterator;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * NewIntranet<br>
 * <br>
 * Cette action prend en charge la cration d'un nouvel intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.4
 * 
 */
public class NewIntranet extends AdminAction {

    private Collection ressources = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public NewIntranet(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("NewIntranet::action()");
        
        // Rcupration de la liste des ressources
        ressources = Config.getInstance().getRessources().values();
        return Boolean.TRUE;
    }
    
    /**
     * Affiche le formulaire de cration d'intranet
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        log("NewIntranet::setXML()");
        
        StringBuffer xml = new StringBuffer();
        xml.append("<ressources>\n");
        Iterator i = ressources.iterator();
        while(i.hasNext()) {
            Ressource tmp = (Ressource)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</ressources>");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }

    /**
	 * Traitement du formulaire
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
    public Boolean createinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("NewIntranet::createinit()");
        
        // Rcupration bouton
        String button = runtimeData.getParameter("butcreer");
		
		// Clic sur le bouton Annuler
		if(button == null) {
			mainChannel.redirect(runtimeData, "defaultadmin");
			return Boolean.FALSE;
		}
        
        // Rcupration paramtres
        String identifiant = runtimeData.getParameter("identifiant");
        String nom = runtimeData.getParameter("nom");
        String ressource = runtimeData.getParameter("ressource");
        
        // Tentative d'accs sans paramtres
		if(identifiant == null || nom == null || ressource == null) {
			log(Priority.ERROR, "NewIntranet::createinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultadmin");		
			return Boolean.FALSE;
		}
		
		// Vrification validit paramtres
		if(identifiant.equals("")) {
			log("NewIntranet::createinit() : Identifiant d'intranet vide");
			Message.message(mainChannel, runtimeData, new MessageBean("L'identifiant est vide"), "newintranet");
			return Boolean.FALSE;
		}
		
		if(!identifiant.matches("[A-Z0-9_]+")) {
		    log("NewIntranet::createinit() : Identifiant invalide");
		    Message.message(mainChannel, runtimeData, new MessageBean("L'identifiant ne doit comporter que des majuscules, des chiffres et le caractre _"), "newintranet");
		    return Boolean.FALSE;
		}
		
		if(nom.equals("")) {
			log("NewIntranet::createinit() : Nom vide");
			Message.message(mainChannel, runtimeData, new MessageBean("Le nom est vide"), "newintranet");
			return Boolean.FALSE;
		}
		
		// Cration de l'intranet
		Intranet intranet = new Intranet();
		intranet.setId(identifiant);
		intranet.setName(nom);
		intranet.setRessource(ressource);
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		try {
		    data.createIntranet(intranet);
		    store.createIntranet(intranet);
		    data.commit();
		}
		catch(DataException e) {
		    log(Priority.ERROR, "NewIntranet::createinit() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
			return Boolean.FALSE;
		}
		catch(StorageException e) {
		    log(Priority.ERROR, "NewIntranet::createinit() : StorageException : " + e);
			log(Priority.FATAL, "NewIntranet::createinit() : Possible incoh\u00E9rence du syst\u00E8me de fichiers !");
			data.rollback();
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
			return Boolean.FALSE;
		}
		
		mainChannel.redirect(runtimeData, "defaultadmin");
        return Boolean.FALSE;
    }
}
