package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.groups.GroupException;
import org.esupportail.portal.channels.CIntranet.groups.GroupFactory;
import org.esupportail.portal.channels.CIntranet.groups.IGroupManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ListMimes<br>
 * <br>
 * Cette action prend en charge l'affichage de la liste des extensions acceptes<br>
 * par le canal intranet et l'ajout d'un nouvelle extension avec son type MIME associ<br>
 * 
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */
public class SuperUsers extends AdminAction {

    private Collection superusers = null;
    private Hashtable map = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public SuperUsers(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        log("SuperUsers::action()");
        
        // Rcupration IDataReadManager
        IDataControler data = DataFactory.make();
        
        // Rcupration Super Utilisateurs
        try {
            superusers = data.getSuperUsers();
        }
        catch(DataException e) {
            log(Priority.ERROR, "SuperUsers::action() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IGroupManager
        IGroupManager groups = GroupFactory.make();
        
        // Rcupration displaynames
        map = new Hashtable();
        Iterator i = superusers.iterator();
        while(i.hasNext()) {
            try {
                String tmp = (String)i.next();
                String display = groups.getUserDisplayName(tmp);
                map.put(tmp, display);
            }
            catch(GroupException e) {
                log(Priority.ERROR, "SuperUsers::action() : " + e);
            }
        }
        
        return Boolean.TRUE;
    }

    
    /**
     * Affiche la liste des Super Utilisateurs
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        log("SuperUsers::setXML()");
        StringBuffer xml = new StringBuffer();
        xml.append("<users>\n");
        Enumeration e = map.keys();
        while(e.hasMoreElements()) {
            String tmp = (String)e.nextElement();
            xml.append("<user login=\"" + tmp + "\" displayname=\"" + (String)map.get(tmp) + "\" />\n");
        }
        xml.append("</users>");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }

    /**
     * Suppression d'un Super Utilisateur
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("SuperUsers::delinit()");
        
        // Rcupration paramtres
        String login = runtimeData.getParameter("login");
        
        // Tentative d'accs sans paramtre
        if(login == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataControler
        IDataControler data = DataFactory.make();
        
        // Suppression du Super Utilisateur
        try {
            data.removeSuperUser(login);
        }
        catch(DataException e) {
            log(Priority.ERROR, "SuperUsers::delinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "su");        
        return Boolean.FALSE;
    }
    
    /**
     * Ajout d'un type MIME
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean addinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        log("SuperUsers::addinit()");
        
        // Rcupration paramtres
        String login = runtimeData.getParameter("login");
        
        // Tentative d'accs sans paramtre
        if(login == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IGroupManager
        IGroupManager groups = GroupFactory.make();
        
        // Vrification validit du login
        try {
            groups.getUserDisplayName(login);            
        }
        catch(GroupException e) {
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "su");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataControler
        IDataControler data = DataFactory.make();
        
        // Ajout du Super Utilisateur
        try {
            data.addSuperUser(login);
        }
        catch(DataException e) {
            log(Priority.ERROR, "SuperUsers::addinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "su");        
        return Boolean.FALSE;
    }
}
