package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;

/**
 * Document<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives  un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class Document {
	
	public static int FILE = 0;
	public static int LINK = 1;

	private String id = null;
	private String intranet = null;
	private String folder = null;
	private String file = null;
	private String name = null;
	private String extension = null;
	private String description = null;
	private int type = 0;
	private boolean locked = false;
	private boolean newdoc = false;
	private String author = null;
	private String modificationDate = null;
	private String limitDate = null;
	private boolean limit = false;
	private String order = null;
	
	/**
	 * Constructeur
	 */
	public Document() {
	}

	/**
	 * Identifiant de document
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * Identifiant de document
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Identifiant d'intranet
	 * @return
	 */
	public String getIntranet() {
		return intranet;
	}

	/**
	 * Identifiant d'intranet
	 * @param intranet
	 */
	public void setIntranet(String intranet) {
		this.intranet = intranet;
	}

	/**
	 * Identifiant de dossier
	 * @return
	 */
	public String getFolder() {
		return folder;
	}

	/**
	 * Identifiant de dossier
	 * @param folder
	 */
	public void setFolder(String folder) {
		this.folder = folder;
	}

	/**
	 * Nom du fichier (avec extension)
	 * @return
	 */
	public String getFile() {
		return file;
	}

	/**
	 * Nom du fichier (avec extension)
	 * @param file
	 */
	public void setFile(String file) {
		this.file = file;
		if (type == Document.FILE) {
			int index = file.lastIndexOf('.');
			if (index == -1) {
				// Houston, we've got a problem
			} else {
				setExtension(file.substring(index));
				this.name = file.substring(0, index);
			}
		} else {
			setExtension(".html");
		}
	}

	/**
	 * Le nom du fichier (sans extension)
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * Le nom du fichier (sans extension)
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
		if (type == Document.FILE) {
			this.file = this.name + this.extension;
		}
	}

	/**
	 * L'extension du fichier
	 * @return
	 */
	public String getExtension() {
		return extension;
	}

	/**
	 * L'extension du fichier
	 * @param extension
	 */
	private void setExtension(String extension) {
		this.extension = extension;
	}

	/**
	 * La description du document
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * La description du document
	 * @param description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Le type de document, Document.FILE ou Document.LINK
	 * @return
	 */
	public int getType() {
		return type;
	}

	/**
	 * Le type de document, Document.FILE ou Document.LINK
	 * @param type
	 */
	public void setType(int type) {
		this.type = type;
	}


	/**
	 * Si le document est valide
	 * @return
	 */
	public boolean isValid() {
		return id.startsWith("v");
	}

	/**
	 * Si le document est verrouill
	 * @return
	 */
	public boolean isLocked() {
		return locked;
	}

	/**
	 * Verrouillage du document
	 * @param locked
	 */
	public void setLocked(boolean locked) {
		this.locked = locked;
	}

	/**
	 * Nouveau document
	 * @return
	 */
	public boolean isNew() {
	    return newdoc;
	}
	
	/**
	 * Nouveau document
	 * @param newdoc
	 */
	public void setNew(boolean newdoc) {
	    this.newdoc = newdoc;
	}
	
	/**
	 * L'auteur du document
	 * @return
	 */
	public String getAuthor() {
		return author;
	}

	/**
	 * L'auteur du document
	 * @param author
	 */
	public void setAuthor(String author) {
		this.author = author;
	}

	/**
	 * La date de dernire modification
	 * @return
	 */
	public String getModificationDate() {
		return modificationDate;
	}

	/**
	 * La date de dernire modification
	 * @param modificationDate
	 */
	public void setModificationDate(String modificationDate) {
		this.modificationDate = modificationDate;
	}
	
	/**
	 * La date de premption
	 * @return
	 */
	public String getLimitDate() {
		return limitDate;
	}

	/**
	 * La date de premption
	 * @param limitDate
	 */
	public void setLimitDate(String limitDate) {
		this.limitDate = limitDate;
		String today = Date.getCurrentDate();
		if(limitDate.compareTo(today) < 0) {
		    limit = true;
		}
	}
	
	/**
	 * Document prim
	 * @return
	 */
	public boolean isLimited() {
	    return limit;
	}

	/**
	 * Le numro d'ordre du document
	 * @return
	 */
	public String getOrder() {
	    return order;
	}
	
	/**
	 * Le numro d'ordre du document
	 * @param order
	 */
	public void setOrder(String order) {
	    this.order = order;
	}
	
	/**
	 * La reprsentation XML de ce document
	 * @return
	 */
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();
		xml.append("<document ");
		xml.append("id=\"" + getId() + "\" ");
		xml.append("folder=\"" + getFolder() + "\" ");
		xml.append("file=\"" + getFile() + "\" ");
		xml.append("name=\"" + getName() + "\" ");
		xml.append("description=\"" + getDescription() + "\" ");
		xml.append("author=\"" + getAuthor() + "\" ");
		xml.append("modificationdate=\"" + Date.formatDate(getModificationDate()) + "\" ");
		xml.append("limitdate=\"" + getLimitDate() + "\" ");
		if(getType() == Document.FILE) {
			xml.append("type=\"file\" ");
			xml.append("ext=\"" + getExtension() + "\" ");
		}
		else {
			xml.append("type=\"link\" ");
		}
		xml.append("valid=\"" + isValid() + "\" ");
		xml.append("locked=\"" + isLocked() + "\" ");
		xml.append("order=\"" + getOrder() + "\" />");
		return xml.toString();
	}
}
