package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Hashtable;

/**
 * Ressource<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives  la ressource de stockage d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.2
 * 
 */

public class Ressource {
	
	private String name = null;
	private String classname = null;
	private String description = null;
	private Hashtable parameters = null;
	
	/**
	 * Constructeur
	 */
	public Ressource() {
		parameters = new Hashtable();
	}

	/**
	 * Le nom de cette ressource
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * Le nom de cette ressource
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * La classe d'implmentation de cette ressource
	 * @return
	 */
	public String getClassname() {
		return classname;
	}

	/**
	 * La classe d'implmentation de cette ressource
	 * @param classname
	 */
	public void setClassname(String classname) {
		this.classname = classname;
	}

	/**
	 * La description de cette ressource
	 * @return
	 */
	public String getDescription() {
	    return description;
	}
	
	/**
	 * La description de cette ressource
	 * @param description
	 */
	public void setDescription(String description) {
	    if(description != null) {
	        this.description = description;
	    }
	    else {
	        this.description = "Aucune description";
	    }
	}
	
	/**
	 * Ajout d'un paramtre spcifique  cette ressource
	 * @param name Le nom de cette ressource
	 * @param value La classe d'implmentation de cette ressource
	 */
	public void addParameter(String name, String value) {
		parameters.put(name, value);
	}

	/**
	 * Les paramtres de cette ressource
	 * @return
	 */
	public Hashtable getParameters() {
		return parameters;
	}
	
	/**
	 * La reprsentation XML de cette ressource
	 * @return
	 */
	public String toXMLString() {
	    StringBuffer xml = new StringBuffer();
	    xml.append("<ressource name=\"" + getName() + "\" ");
	    xml.append("classname=\"" + getClassname() + "\" ");
	    xml.append("description=\"" + getDescription() + "\" />\n");
	    return xml.toString();
	}
}
