package org.esupportail.portal.channels.CIntranet.config;

import java.util.Hashtable;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.utils.channels.ConfigChannel;
import org.jasig.portal.services.LogService;

/**
 * Config<br>
 * <br>
 * Classe implmentant un mcanisme de singleton permettant la lecture du fichier<br>
 * de configuration du canal Intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class Config extends ConfigChannel implements IntranetConfig, SizeLimiter {

	private static Config singleton = null;
	private static Priority nivlog = Priority.DEBUG;
	
	private String dataControler;
	private String dataDocument;
	private String dataFolder;
	private String dataIntranet;
	private String dataMIME;
	private String dataOrder;
	private String dataPopulation;
	private String dataPublicator;
	private String dataSearch;
	private String dataSU;
	private String dataValidator;
	private String groupManager;
	private String securityManager;
	private Hashtable storageControlers;
	private String sizeUpload;
	private String annuaires;

	/**
	 * Rcupration du singleton
	 * @return
	 */
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	/**
	 * Le fichier de configuration
	 * @return
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CIntranet/CIntranet.xml";
	}
	
	/**
	 * Mthode permettant la lecture de la partie spcifique<br>
	 * au canal Intranet du fichier de configuration
	 */
	protected void customDigester() {
		LogService.log(nivlog, "Config::customDigester()");
		// Implmentation du IDataControler
		dig.addCallMethod("config/implementations/dataControler", "setDataControler", 1);
		dig.addCallParam("config/implementations/dataControler", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataDocument", "setDataDocument", 1);
			dig.addCallParam("config/implementations/dataControler/dataDocument", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataFolder", "setDataFolder", 1);
			dig.addCallParam("config/implementations/dataControler/dataFolder", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataIntranet", "setDataIntranet", 1);
			dig.addCallParam("config/implementations/dataControler/dataIntranet", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataMIME", "setDataMIME", 1);
			dig.addCallParam("config/implementations/dataControler/dataMIME", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataOrder", "setDataOrder", 1);
			dig.addCallParam("config/implementations/dataControler/dataOrder", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataPopulation", "setDataPopulation", 1);
			dig.addCallParam("config/implementations/dataControler/dataPopulation", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataPublicator", "setDataPublicator", 1);
			dig.addCallParam("config/implementations/dataControler/dataPublicator", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataSearch", "setDataSearch", 1);
			dig.addCallParam("config/implementations/dataControler/dataSearch", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataSU", "setDataSU", 1);
			dig.addCallParam("config/implementations/dataControler/dataSU", 0, "classname");
			dig.addCallMethod("config/implementations/dataControler/dataValidator", "setDataValidator", 1);
			dig.addCallParam("config/implementations/dataControler/dataValidator", 0, "classname");
		
		// Implmentation du IGroupManager
		dig.addCallMethod("config/implementations/groupManager", "setGroupManager", 1);
		dig.addCallParam("config/implementations/groupManager", 0, "classname");
		
		// Implmentation du ISecurityManager
		dig.addCallMethod("config/implementations/securityManager", "setSecurityManager", 1);
		dig.addCallParam("config/implementations/securityManager", 0, "classname");
		
		// Ressources
		
		storageControlers = new Hashtable();
		
		dig.addObjectCreate("config/storages/storage", Ressource.class);
		dig.addSetProperties("config/storages/storage");
		
			dig.addCallMethod("config/storages/storage/parameters/parameter", "addParameter", 2);
			dig.addCallParam("config/storages/storage/parameters/parameter", 0, "name");
			dig.addCallParam("config/storages/storage/parameters/parameter", 1, "value");
		
		dig.addSetNext("config/storages/storage", "addRessource");
		
		dig.addCallMethod("config/annuaires", "setAnnuaires", 1);
		dig.addCallParam("config/annuaires", 0, "list");
		
		dig.addCallMethod("config/fileupload", "setSizeUpload", 1);
		dig.addCallParam("config/fileupload", 0, "size");
	}

	/**
	 * La classe d'implmentation du IDataControler
	 * @param classname
	 */
	public void setDataControler(String classname) {
		LogService.log(
			nivlog,
			"Config::setDataControler() : classname = " + classname);
		dataControler = classname;
	}

	/**
	 * La classe d'implmentation du IDataControler
	 * @return
	 */
	public String getDataControler() {
		LogService.log(nivlog, "Config::getDataControler() : "
			+ dataControler);
		return dataControler;
	}
	
	/**
	 * La classe d'implmentation du IDataDocument
	 * @return
	 */
	public String getDataDocument() {
		LogService.log(nivlog, "Config::getDataDocument() : "
				+ dataDocument);
			return dataDocument;
	}

	/**
	 * La classe d'implmentation du IDataDocument
	 * @param classname
	 */
	public void setDataDocument(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataDocument() : classname = " + classname);
			dataDocument = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataFolder
	 * @return
	 */
	public String getDataFolder() {
		LogService.log(nivlog, "Config::getDataFolder() : "
				+ dataFolder);
			return dataFolder;
	}

	/**
	 * La classe d'implmentation du IDataFolder
	 * @param classname
	 */
	public void setDataFolder(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataFolder() : classname = " + classname);
			dataFolder = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataIntranet
	 * @return
	 */
	public String getDataIntranet() {
		LogService.log(nivlog, "Config::getDataIntranet() : "
				+ dataIntranet);
			return dataIntranet;
	}

	/**
	 * La classe d'implmentation du IDataIntranet
	 * @param classname
	 */
	public void setDataIntranet(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataIntranet() : classname = " + classname);
			dataIntranet = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataMIME
	 * @return
	 */
	public String getDataMIME() {
		LogService.log(nivlog, "Config::getDataMIME() : "
				+ dataMIME);
			return dataMIME;
	}

	/**
	 * La classe d'implmentation du IDataMIME
	 * @param classname
	 */
	public void setDataMIME(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataMIME() : classname = " + classname);
			dataMIME = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataOrder
	 * @return
	 */
	public String getDataOrder() {
		LogService.log(nivlog, "Config::getDataOrder() : "
				+ dataOrder);
			return dataOrder;
	}

	/**
	 * La classe d'implmentation du IDataOrder
	 * @param classname
	 */
	public void setDataOrder(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataOrder() : classname = " + classname);
			dataOrder = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataPopulation
	 * @return
	 */
	public String getDataPopulation() {
		LogService.log(nivlog, "Config::getDataPopulation() : "
				+ dataPopulation);
			return dataPopulation;
	}

	/**
	 * La classe d'implmentation du IDataPopulation
	 * @param classname
	 */
	public void setDataPopulation(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataPopulation() : classname = " + classname);
			dataPopulation = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataPublicator
	 * @return
	 */
	public String getDataPublicator() {
		LogService.log(nivlog, "Config::getDataPublicator() : "
				+ dataPublicator);
			return dataPublicator;
	}

	/**
	 * La classe d'implmentation du IDataPublicator
	 * @param classname
	 */
	public void setDataPublicator(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataPublicator() : classname = " + classname);
			dataPublicator = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataSearch
	 * @return
	 */
	public String getDataSearch() {
		LogService.log(nivlog, "Config::getDataSearch() : "
				+ dataSearch);
			return dataSearch;
	}

	/**
	 * La classe d'implmentation du IDataSearch
	 * @param classname
	 */
	public void setDataSearch(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataSearch() : classname = " + classname);
			dataSearch = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataSU
	 * @return
	 */
	public String getDataSU() {
		LogService.log(nivlog, "Config::getDataSU() : "
				+ dataSU);
			return dataSU;
	}

	/**
	 * La classe d'implmentation du IDataSU
	 * @param classname
	 */
	public void setDataSU(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataSU() : classname = " + classname);
			dataSU = classname;
	}
	
	/**
	 * La classe d'implmentation du IDataValidator
	 * @return
	 */
	public String getDataValidator() {
		LogService.log(nivlog, "Config::getDataValidator() : "
				+ dataValidator);
			return dataValidator;
	}

	/**
	 * La classe d'implmentation du IDataValidator
	 * @param classname
	 */
	public void setDataValidator(String classname) {
	    LogService.log(
				nivlog,
				"Config::setDataValidator() : classname = " + classname);
			dataValidator = classname;
	}

	/**
	 * La classe d'implmentation du IGroupManager
	 * @param classname
	 */
	public void setGroupManager(String classname) {
		LogService.log(
			nivlog,
			"Config::setGroupManager() : classname = " + classname);
		groupManager = classname;
	}

	/**
	 * La classe d'implmentation du IGroupManager
	 * @return
	 */
	public String getGroupManager() {
		LogService.log(nivlog, "Config::getGroupManager()");
		return groupManager;
	}

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @param classname
	 */
	public void setSecurityManager(String classname) {
		LogService.log(
			nivlog,
			"Config::setSecurityManager() : classname = " + classname);
		securityManager = classname;
	}

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @return
	 */
	public String getSecurityManager() {
		LogService.log(nivlog, "Config::getSecurityManager()");
		return securityManager;
	}


	/**
	 * Ajout d'une ressource physique de stockage
	 * @param res
	 */
	public void addRessource(Ressource res) {
		LogService.log(nivlog, "Config::addRessource() : " + res.getName() + " " + res.getClassname());
		storageControlers.put(res.getName(), res);
	}
	
	/**
	 * La liste des ressources physiques de stockage
	 * @return
	 */
	public Hashtable getRessources() {
		LogService.log(nivlog, "Config::getRessources()");
		return storageControlers;
	}

	/**
	 * La taille limite des fichiers uploads en octets
	 * @param size
	 */
	public void setSizeUpload(String size) {
		sizeUpload = size;
	}

	/**
	 * La taille limite des fichiers uploads en octets
	 * @return
	 */
	public int getSizeUpload() {
		return new Integer(sizeUpload).intValue();
	}

	/**
	 * La liste des annuaires  utiliser
	 * @return
	 */
	public String getAnnuaires() {
	    return annuaires;
	}
	
	/**
	 * La liste des annuaires  utiliser
	 * @param liste
	 */
	public void setAnnuaires(String liste) {
	    annuaires = liste;
	}
}
