package org.esupportail.portal.channels.CIntranet.data;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.jasig.portal.services.LogService;

/**
 * DataFactory<br>
 * <br>
 * Fabrique de IDataControler et de sous-classes d'accs aux donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class DataFactory {
	
	private static Priority nivlog = Priority.DEBUG;
	
	public static IDataControler make() {
	    Class dataControlerClass = null;
		Object dataControlerObject = null;
		IDataControler res = null;
		String classname = Config.getInstance().getDataControler();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataControler " + classname);
		    dataControlerClass = Class.forName(classname);
		    dataControlerObject = dataControlerClass.newInstance();
		    res = (IDataControler)dataControlerObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataControler " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataDocument makeDocument() {
	    Class dataDocumentClass = null;
		Object dataDocumentObject = null;
		IDataDocument res = null;
		String classname = Config.getInstance().getDataDocument();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataDocument " + classname);
		    dataDocumentClass = Class.forName(classname);
		    dataDocumentObject = dataDocumentClass.newInstance();
		    res = (IDataDocument)dataDocumentObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataDocument " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataFolder makeFolder() {
	    Class dataFolderClass = null;
		Object dataFolderObject = null;
		IDataFolder res = null;
		String classname = Config.getInstance().getDataFolder();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataFolder " + classname);
		    dataFolderClass = Class.forName(classname);
		    dataFolderObject = dataFolderClass.newInstance();
		    res = (IDataFolder)dataFolderObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataFolder " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataIntranet makeIntranet() {
	    Class dataIntranetClass = null;
		Object dataIntranetObject = null;
		IDataIntranet res = null;
		String classname = Config.getInstance().getDataIntranet();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataIntranet " + classname);
		    dataIntranetClass = Class.forName(classname);
		    dataIntranetObject = dataIntranetClass.newInstance();
		    res = (IDataIntranet)dataIntranetObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataIntranet " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataMIME makeMIME() {
	    Class dataMIMEClass = null;
		Object dataMIMEObject = null;
		IDataMIME res = null;
		String classname = Config.getInstance().getDataMIME();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataMIME " + classname);
		    dataMIMEClass = Class.forName(classname);
		    dataMIMEObject = dataMIMEClass.newInstance();
		    res = (IDataMIME)dataMIMEObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataMIME " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataOrder makeOrder() {
	    Class dataOrderClass = null;
		Object dataOrderObject = null;
		IDataOrder res = null;
		String classname = Config.getInstance().getDataOrder();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataOrder " + classname);
		    dataOrderClass = Class.forName(classname);
		    dataOrderObject = dataOrderClass.newInstance();
		    res = (IDataOrder)dataOrderObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataOrder " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataPopulation makePopulation() {
	    Class dataPopulationClass = null;
		Object dataPopulationObject = null;
		IDataPopulation res = null;
		String classname = Config.getInstance().getDataPopulation();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataPopulation " + classname);
		    dataPopulationClass = Class.forName(classname);
		    dataPopulationObject = dataPopulationClass.newInstance();
		    res = (IDataPopulation)dataPopulationObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataPopulation " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataPublicator makePublicator() {
	    Class dataPublicatorClass = null;
		Object dataPublicatorObject = null;
		IDataPublicator res = null;
		String classname = Config.getInstance().getDataPublicator();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataPublicator " + classname);
		    dataPublicatorClass = Class.forName(classname);
		    dataPublicatorObject = dataPublicatorClass.newInstance();
		    res = (IDataPublicator)dataPublicatorObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataPublicator " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataSearch makeSearch() {
	    Class dataSearchClass = null;
		Object dataSearchObject = null;
		IDataSearch res = null;
		String classname = Config.getInstance().getDataSearch();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataSearch " + classname);
		    dataSearchClass = Class.forName(classname);
		    dataSearchObject = dataSearchClass.newInstance();
		    res = (IDataSearch)dataSearchObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataSearch " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataSU makeSU() {
	    Class dataSUClass = null;
		Object dataSUObject = null;
		IDataSU res = null;
		String classname = Config.getInstance().getDataSU();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataSU " + classname);
		    dataSUClass = Class.forName(classname);
		    dataSUObject = dataSUClass.newInstance();
		    res = (IDataSU)dataSUObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataSU " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	public static IDataValidator makeValidator() {
	    Class dataValidatorClass = null;
		Object dataValidatorObject = null;
		IDataValidator res = null;
		String classname = Config.getInstance().getDataValidator();
		
		if(classname == null) {
		    LogService.log(Priority.ERROR, "DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    LogService.log(nivlog, "DataFactory::make() : Tentative d'instanciation du DataValidator " + classname);
		    dataValidatorClass = Class.forName(classname);
		    dataValidatorObject = dataValidatorClass.newInstance();
		    res = (IDataValidator)dataValidatorObject;
		}
		catch(Exception e) {
		    res = null;
		    LogService.log(Priority.ERROR, "DataFactory::make() : Echec de l'instanciation du DataValidator " + classname);
		    LogService.log(Priority.ERROR, "DataFactory::make() : Exception " + e);
		}
		return res;
	}
}
