package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.LogService;

/**
 * DataIntranet<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataIntranet implements IDataIntranet {
    
    private static Priority nivlog = Priority.DEBUG;

    /**
	 * Rcupration d'un intranet
	 * @param query La connexion  utiliser
	 * @param id L'identifiant d'intranet
	 * @return L'intranet correspondant
	 * @throws DataException
	 */
    public Intranet getIntranet(Query query, String id) throws DataException {
        LogService.log(nivlog, "DataIntranet::getIntranet()");
		
		Intranet res = new Intranet();
		String sql = "SELECT ID_DOS, INT_INTRANET.* FROM INT_INTRANET, INT_DOSSIER WHERE INT_INTRANET.ID_INT = '" + id + "' AND INT_DOSSIER.ID_INT = '" + id + "' AND INT_DOSSIER.ID_PAR = 0";
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			if(!result.next()) {
				LogService.log(nivlog, "DataIntranet::getIntranet() : Aucun intranet ayant pour ID = " + id);
				throw new DataException("Impossible d'acc\u00E9der \u00E0 cet intranet");
			}
			res.setId(id);
			res.setName(result.getString("NOM_INT"));
			res.setRessource(result.getString("ID_RES"));
			res.setRoot(result.getString("ID_DOS"));
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataIntranet::getIntranet() : " + e);
			LogService.log(Priority.ERROR, "DataIntranet::getIntranet() : SQL : " + sql);
			throw new DataException("Impossible d'acc\u00E9der \u00E0 cet intranet");
		}
		return res;
    }

    /**
	 * Rcupration de la liste de tous les intranets
	 * @param query La connexion  utiliser
	 * @return La liste de tous les intranets
	 * @throws DataException
	 */
    public Collection getIntranets(Query query) throws DataException {
        LogService.log(nivlog, "DataIntranet::getIntranets()");
		Collection res = new Vector();
		
		String sql = "SELECT INT_INTRANET.*, INT_DOSSIER.ID_DOS FROM INT_INTRANET, INT_DOSSIER WHERE INT_DOSSIER.ID_PAR = 0 AND INT_DOSSIER.ID_INT = INT_INTRANET.ID_INT ORDER BY NOM_INT ASC";
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				Intranet tmp = new Intranet();
				tmp.setId(result.getString("ID_INT"));
				tmp.setName(result.getString("NOM_INT"));
				tmp.setRessource(result.getString("ID_RES"));
				tmp.setRoot(result.getString("ID_DOS"));
				res.add(tmp);
			}
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataIntranet::getIntranets() : " + e);
			LogService.log(Priority.ERROR, "DataIntranet::getIntranets() : SQL : " + sql);
			throw new DataException("Impossible d'acc\u00E9der aux intranets");
		}
		return res;
    }

    /**
	 * Cration d'un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet  crer
	 */
    public void createIntranet(Query query, Intranet intranet) throws DataException {
        LogService.log(nivlog, "DataIntranet::createIntranet()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_INTRANET(ID_INT, NOM_INT, DOC_INT, ID_RES) VALUES(");
		sql.append("'" + intranet.getId() + "', ");
		sql.append("'" + RDBMServices.sqlEscape(intranet.getName()) + "', ");
		sql.append("1, ");
		sql.append("'" + intranet.getRessource() + "')");		
		
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataIntranet::createIntranet() : " + e);
			LogService.log(Priority.ERROR, "DataIntranet::createIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors de la cr\u00E9ation de l'intranet");
		}
    }

    /**
	 * Suppression d'un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet  supprimer
	 * @throws DataException
	 */
    public void removeIntranet(Query query, Intranet intranet) throws DataException {
        LogService.log(nivlog, "DataIntranet::removeIntranet()");
		
        String sql = "DELETE FROM INT_INTRANET WHERE ID_INT = '" + intranet.getId() + "'";
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            LogService.log(Priority.ERROR, "DataIntranet::removeIntranet() : " + e);
			LogService.log(Priority.ERROR, "DataIntranet::removeIntranet() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression de l'intranet");
        }
    }

    /**
	 * Test de l'existence d'un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet dont on teste l'existence
	 * @return boolean true si l'intranet existe, false sinon
	 * @throws DataException
	 */
    public boolean intranetExist(Query query, Intranet intranet) throws DataException {
        LogService.log(nivlog, "DataIntranet::intranetExist()");
	    
	    String sql = "SELECT * FROM INT_INTRANET WHERE ID_INT = '" + intranet.getId() + "'";
	    try {
	        query.setSql(sql);
	        query.select();
	        ResultSet result = query.getRs();
	        if(result.next()) {
	            return true;
	        }
	        return false;
	    }
	    catch(SQLException e) {
	        LogService.log(Priority.ERROR, "DataIntranet::intranetExist() : " + e);
			LogService.log(Priority.ERROR, "DataIntranet::intranetExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence de l'intranet");
	    }
    }
}
