package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Mime;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.services.LogService;

/**
 * DataMIME<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataMIME implements IDataMIME {
    
    private static Priority nivlog = Priority.DEBUG;

    /**
	 * Rcupration des types MIME valides
	 * @param query La connexion  utiliser
	 * @return La liste des types MIME
	 * @throws DataException
	 */
    public Collection getMIMEs(Query query) throws DataException {
        LogService.log(nivlog, "DataMIME::getMIMEs()");
		Collection res = new Vector();
		
		String sql = "SELECT * FROM INT_MIME ORDER BY EXT_MIME ASC";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				Mime tmp = new Mime();
				tmp.setExtension(result.getString("EXT_MIME"));
				tmp.setType(result.getString("TYPE_MIME"));
				res.add(tmp);
			}
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataMIME::getMIMEs() : " + e);
			LogService.log(Priority.ERROR, "DataMIME::getMIMEs() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des types MIME");
		}
		return res;
    }

    /**
	 * Cration d'un type MIME
	 * @param query La connexion  utiliser
	 * @param mime Le type MIME  crer
	 */
    public void createMIME(Query query, Mime mime) throws DataException {
        LogService.log(nivlog, "DataMIME::createMIME()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_MIME(EXT_MIME, TYPE_MIME) VALUES(");
		sql.append("'" + mime.getExtension() + "', ");
		sql.append("'" + mime.getType() + "')");
		
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataMIME::createMIME() : " + e);
			LogService.log(Priority.ERROR, "DataMIME::createMIME() : SQL : " + sql);
			throw new DataException("Erreur lors de la cr\u00E9ation du type MIME");
		}
    }

    /**
	 * Suppression d'un type MIME
	 * @param query La connexion  utiliser
	 * @param extension L'extension associe au type MIME
	 * @throws DataException
	 */
    public void removeMIME(Query query, String extension) throws DataException {
        LogService.log(nivlog, "DataMIME::removeMIME()");
		
		String sql = "DELETE FROM INT_MIME WHERE EXT_MIME = '" + extension + "'";
		
		try {
			query.setSql(sql);
			query.delete();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataMIME::removeMIME() : " + e);
			LogService.log(Priority.ERROR, "DataMIME::removeMIME() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du type MIME");
		}
    }
    
    /**
	 * Vrifie la validit d'un type MIME
	 * @param query La connexion  utiliser
	 * @param extension L'extension  tester
	 * @return boolean True si le type est valide, false sinon
	 * @throws DataException
	 */
	public boolean isValidMIME(Query query, String extension) throws DataException {
	    LogService.log(nivlog, "DataMIME::isValidMIME()");
	    
	    String sql = "SELECT * FROM INT_MIME WHERE EXT_MIME = '" + extension + "'";
	    try {
	        query.setSql(sql);
	        query.select();
	        ResultSet result = query.getRs();
	        if(result.next()) {
	            return true;
	        }
	        return false;
	    }
	    catch(SQLException e) {
	        LogService.log(Priority.ERROR, "DataMIME::isValidMIME() : " + e);
			LogService.log(Priority.ERROR, "DataMIME::isValidMIME() : SQL : " + sql);
			throw new DataException("Erreur lors du test du type MIME");
	    }
	}
}
