package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Priority;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.services.LogService;

/**
 * DataPopulation<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataPopulation implements IDataPopulation {
    
    private static Priority nivlog = Priority.DEBUG;

    /**
	 * Rcupration d'une population
	 * @param query La connexion  utiliser
	 * @param id L'identifiant d'intranet
	 * @return La population de l'intranet
	 * @throws DataException
	 */
    public Population getPopulation(Query query, String id) throws DataException {
        LogService.log(nivlog, "DataPopulation::getPopulation()");
		Population res = new Population();
		Collection groups = new Vector();
		Collection users = new Vector();
		
		StringBuffer sql1 = new StringBuffer();
		sql1.append("SELECT ID_POP FROM INT_POPULATION WHERE ");
		sql1.append("ID_INT = '" + id + "' AND TYPE_POP = 'U'");
		
		StringBuffer sql2 = new StringBuffer();
		sql2.append("SELECT ID_POP FROM INT_POPULATION WHERE ");
		sql2.append("ID_INT = '" + id + "' AND TYPE_POP = 'G'");
		
		
		try {
			query.setSql(sql1.toString());
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				users.add(result.getString("ID_POP"));
			}
			res.setUsers(users);
			query.setSql(sql2.toString());
			query.select();
			result = query.getRs();
			while(result.next()) {
				groups.add(result.getString("ID_POP"));
			}
			res.setGroups(groups);
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataPopulation::getPopulation() : " + e);
			throw new DataException("Erreur lors de la lecture de la population");
		}
		return res;
    }

    /**
	 * Ajout d'une population
	 * @param query La connexion  utiliser
	 * @param population La population  ajouter
	 */
    public void addPopulation(Query query, Population population) throws DataException {
        LogService.log(nivlog, "DataPopulation::getPopulation()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_POPULATION(ID_INT, TYPE_POP, ID_POP) VALUES(");
		sql.append("'" + population.getIntranet() + "', ");
		sql.append("'%T', ");
		sql.append("'%I')");
		
		try {
			Iterator i = population.getUsers().iterator();
			String req = sql.toString().replaceFirst("%T", "U");
			while(i.hasNext()) {
				String tmp = (String)i.next();
				String reqtmp = req.replaceFirst("%I", tmp);
				query.setSql(reqtmp);
				query.insert();
			}
			
			i = population.getGroups().iterator();
			req = sql.toString().replaceFirst("%T", "G");
			while(i.hasNext()) {
				String tmp = (String)i.next();
				String reqtmp = req.replaceFirst("%I", tmp);
				query.setSql(reqtmp);
				query.insert();
			}
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataPopulation::addPopulation() : " + e);
			LogService.log(Priority.ERROR, "DataPopulation::addPopulation() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout de la population");
		}
    }

    /**
	 * Suppression d'une population
	 * @param query La connexion  utiliser
	 * @param intranet L'identifiant de l'intranet dont on souhaite supprimer la population
	 * @throws DataException
	 */
    public void removePopulation(Query query, String intranet) throws DataException {
        LogService.log(nivlog, "DataPopulation::removePopulation()");
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_POPULATION WHERE ");
		sql.append("ID_INT = '" + intranet + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			LogService.log(Priority.ERROR, "DataPopulation::removePopulation() : " + e);
			LogService.log(Priority.ERROR, "DataPopulation::removePopulation() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression de la population");
		}
    }
}
