package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Path;
import org.esupportail.portal.channels.CIntranet.beans.SubFolder;
import org.esupportail.portal.utils.database.Query;

/**
 * IDataFolder<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux dossiers<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataFolder {

    /**
	 * Rcupration d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return Le dossier
	 * @throws DataException
	 */
	public Folder getFolder(Query query, String id) throws DataException;
	
	/**
	 * Rcupration d'un sous-dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du sous-dossier
	 * @return Le sous-dossier
	 * @throws DataException
	 */
	public SubFolder getSubFolder(Query query, String id) throws DataException;
	
	/**
	 * Rcupration des sous-dossiers
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier parent
	 * @return La liste des sous-dossiers
	 * @throws DataException
	 */
	public Collection getSubFolders(Query query, String id) throws DataException;
	
	/**
	 * Cration d'un dossier
	 * @param query La connexion  utiliser
	 * @param folder Le dossier  crer
	 * @return L'identifiant du dossier cr
	 */
	public void createFolder(Query query, Folder folder) throws DataException;
	
	/**
	 * Suppression d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
	public void removeFolder(Query query, String id) throws DataException;
	
	/**
	 * Modifie la validation d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param validation True pour activer la validation, false pour la dsactiver
	 * @throws DataException
	 */
	public void setValidation(Query query, String id, boolean validation) throws DataException;
	
	/**
	 * Modifie le nom d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param name Le nouveau nom du dossier
	 * @throws DataException
	 */
	public void setName(Query query, String id, String name) throws DataException;
	
	/**
	 * Identifiant du prochain dossier
	 * @param query La connexion  utiliser
	 * @return int L'identifiant
	 * @throws DataException
	 */
	public int getNextFolder(Query query) throws DataException;
	
	/**
	 * Vrification existence d'un dossier
	 * @return boolean True si le dossier existe, faux sinon
	 * @throws DataException
	 */
	public boolean folderExist(Query query, Folder folder) throws DataException;
	
	/**
	 * Vrifie si un dossier est vide
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return boolean True si le dossier est vide, faux sinon
	 * @throws DataException
	 */
	public boolean isFolderEmpty(Query query, String id) throws DataException;
	
	/**
	 * Construit le chemin d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return Path le chemin du dossier
	 * @throws DataException
	 */
	public Path getPath(Query query, String id) throws DataException;
	
	/**
	 * Retourne la liste de tous les sous-dossiers d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return Collection La liste des sous-dossiers
	 * @throws DataException
	 */
	public Collection getFolderChildren(Query query, String id) throws DataException;
}
